/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.context;

import ch.so.agi.dbeaver.ai.context.TableReferenceResolver;
import ch.so.agi.dbeaver.ai.model.ResolvedTable;
import ch.so.agi.dbeaver.ai.model.ResolvedTableResult;
import ch.so.agi.dbeaver.ai.model.TableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public final class DBeaverTableReferenceResolver
implements TableReferenceResolver {
    private static final Log LOG = Log.getLog(DBeaverTableReferenceResolver.class);
    private static final int MAX_TRAVERSAL_DEPTH = 5;

    @Override
    public ResolvedTableResult resolve(List<TableReference> references) {
        ArrayList<ResolvedTable> resolved = new ArrayList<ResolvedTable>();
        ArrayList<String> warnings = new ArrayList<String>();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        for (TableReference reference : references) {
            try {
                Resolution resolution = this.resolveSingle(reference, (DBRProgressMonitor)monitor);
                if (resolution.table == null) {
                    warnings.add("Unknown table reference: " + reference.canonicalId());
                    continue;
                }
                resolved.add(new ResolvedTable(reference, resolution.fqn, resolution.databaseType, resolution.table, resolution.executionContext));
            }
            catch (Exception e) {
                warnings.add("Failed to resolve reference " + reference.canonicalId() + ": " + e.getMessage());
                LOG.debug((Object)"Failed to resolve table reference", (Throwable)e);
            }
        }
        return new ResolvedTableResult(resolved, warnings);
    }

    private Resolution resolveSingle(TableReference reference, DBRProgressMonitor monitor) throws DBException {
        DBPDataSource dataSource;
        DBPDataSourceContainer container = this.findDataSourceContainer(reference.datasourceName());
        if (container == null) {
            return Resolution.unresolved();
        }
        if (!container.isConnected()) {
            container.connect(monitor, false, false);
        }
        if ((dataSource = container.getDataSource()) == null) {
            return Resolution.unresolved();
        }
        DBCExecutionContext executionContext = DBUtils.getOrOpenDefaultContext((DBSObject)dataSource, (boolean)false);
        DBSEntity table = this.findEntity(dataSource, reference.schemaName(), reference.tableName(), monitor);
        if (table == null) {
            return Resolution.unresolved();
        }
        String fqn = DBUtils.getObjectFullName((DBPDataSource)dataSource, (DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DML);
        String databaseType = this.detectDatabaseType(container, dataSource);
        return new Resolution(table, executionContext, fqn, databaseType);
    }

    private DBSEntity findEntity(DBPDataSource dataSource, String schemaName, String tableName, DBRProgressMonitor monitor) {
        DBSObjectContainer container;
        DBSEntity entity;
        DBSEntity entity2;
        if (dataSource instanceof DBSEntity && this.equalsIgnoreCase((entity2 = (DBSEntity)dataSource).getName(), tableName)) {
            return entity2;
        }
        if (dataSource instanceof DBSObjectContainer && (entity = this.findEntityRecursive(container = (DBSObjectContainer)dataSource, schemaName, tableName, monitor, 5, new HashSet<String>())) != null) {
            return entity;
        }
        DBSObject parent = dataSource.getParentObject();
        if (parent instanceof DBSObjectContainer) {
            DBSObjectContainer container2 = (DBSObjectContainer)parent;
            return this.findEntityRecursive(container2, schemaName, tableName, monitor, 5, new HashSet<String>());
        }
        return null;
    }

    private DBSEntity findEntityRecursive(DBSObjectContainer container, String schemaName, String tableName, DBRProgressMonitor monitor, int depth, Set<String> visited) {
        Collection children;
        block9: {
            DBSObjectContainer schemaContainer;
            DBSEntity tableInSchema;
            DBSEntity tableInSchema2;
            if (depth < 0) {
                return null;
            }
            String containerId = this.containerKey(container);
            if (!visited.add(containerId)) {
                return null;
            }
            if (this.equalsIgnoreCase(container.getName(), schemaName) && (tableInSchema2 = this.findEntityDirectChild(container, tableName, monitor)) != null) {
                return tableInSchema2;
            }
            DBSObject schemaObject = this.findChildIgnoreCase(container, schemaName, monitor);
            if (schemaObject instanceof DBSObjectContainer && (tableInSchema = this.findEntityDirectChild(schemaContainer = (DBSObjectContainer)schemaObject, tableName, monitor)) != null) {
                return tableInSchema;
            }
            children = container.getChildren(monitor);
            if (children != null) break block9;
            return null;
        }
        try {
            for (DBSObject child : children) {
                DBSObjectContainer nested;
                DBSEntity nestedResult;
                DBSEntity entity;
                if (child instanceof DBSEntity && this.equalsIgnoreCase((entity = (DBSEntity)child).getName(), tableName) && child.getParentObject() != null && this.equalsIgnoreCase(child.getParentObject().getName(), schemaName)) {
                    return entity;
                }
                if (!(child instanceof DBSObjectContainer) || (nestedResult = this.findEntityRecursive(nested = (DBSObjectContainer)child, schemaName, tableName, monitor, depth - 1, visited)) == null) continue;
                return nestedResult;
            }
        }
        catch (DBException e) {
            LOG.debug((Object)"Object traversal failed while resolving table", (Throwable)e);
        }
        return null;
    }

    private DBSEntity findEntityDirectChild(DBSObjectContainer container, String tableName, DBRProgressMonitor monitor) {
        Collection children;
        block5: {
            DBSObject child = this.findChildIgnoreCase(container, tableName, monitor);
            if (child instanceof DBSEntity) {
                DBSEntity entity = (DBSEntity)child;
                return entity;
            }
            children = container.getChildren(monitor);
            if (children != null) break block5;
            return null;
        }
        try {
            for (DBSObject object : children) {
                DBSEntity entity;
                if (!(object instanceof DBSEntity) || !this.equalsIgnoreCase((entity = (DBSEntity)object).getName(), tableName)) continue;
                return entity;
            }
        }
        catch (DBException e) {
            LOG.debug((Object)"Failed to resolve direct child table", (Throwable)e);
        }
        return null;
    }

    private DBSObject findChildIgnoreCase(DBSObjectContainer container, String name, DBRProgressMonitor monitor) throws DBException {
        DBSObject direct = container.getChild(monitor, name);
        if (direct != null) {
            return direct;
        }
        Collection children = container.getChildren(monitor);
        if (children == null || children.isEmpty()) {
            return null;
        }
        for (DBSObject child : children) {
            if (!this.equalsIgnoreCase(child.getName(), name)) continue;
            return child;
        }
        return null;
    }

    private DBPDataSourceContainer findDataSourceContainer(String datasourceName) {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        if (workspace == null) {
            return null;
        }
        DBPProject activeProject = workspace.getActiveProject();
        DBPDataSourceContainer fromActive = this.findDataSourceInProject(activeProject, datasourceName);
        if (fromActive != null) {
            return fromActive;
        }
        for (DBPProject project : workspace.getProjects()) {
            DBPDataSourceContainer ds;
            if (Objects.equals(project, activeProject) || (ds = this.findDataSourceInProject(project, datasourceName)) == null) continue;
            return ds;
        }
        return null;
    }

    private DBPDataSourceContainer findDataSourceInProject(DBPProject project, String datasourceName) {
        if (project == null) {
            return null;
        }
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        if (registry == null) {
            return null;
        }
        DBPDataSourceContainer exact = registry.findDataSourceByName(datasourceName);
        if (exact != null) {
            return exact;
        }
        List sources = registry.getDataSources();
        if (sources == null) {
            return null;
        }
        String target = datasourceName.toLowerCase(Locale.ROOT);
        for (DBPDataSourceContainer source : sources) {
            if (source == null || source.getName() == null || !source.getName().toLowerCase(Locale.ROOT).equals(target)) continue;
            return source;
        }
        return null;
    }

    private boolean equalsIgnoreCase(String left, String right) {
        if (left == null || right == null) {
            return false;
        }
        return left.equalsIgnoreCase(right);
    }

    private String containerKey(DBSObjectContainer container) {
        try {
            String id = DBUtils.getObjectFullId((DBSObject)container);
            if (id != null && !id.isBlank()) {
                return id;
            }
        }
        catch (Exception exception) {}
        return container.getClass().getName() + "@" + System.identityHashCode(container);
    }

    private String detectDatabaseType(DBPDataSourceContainer container, DBPDataSource dataSource) {
        String driverName = "";
        if (container != null) {
            try {
                DBPDriver driver = container.getDriver();
                if (driver != null) {
                    driverName = this.firstNonBlank(driver.getFullName(), driver.getName());
                }
            }
            catch (Exception exception) {}
        }
        String dialectName = "";
        if (dataSource != null) {
            try {
                if (dataSource.getSQLDialect() != null) {
                    dialectName = dataSource.getSQLDialect().getDialectName();
                }
            }
            catch (Exception exception) {}
        }
        String normalizedDriver = this.normalizeText(driverName);
        String normalizedDialect = this.normalizeText(dialectName);
        if (!(normalizedDriver.isBlank() || normalizedDialect.isBlank() || normalizedDriver.equalsIgnoreCase(normalizedDialect))) {
            return normalizedDriver + " (Dialect: " + normalizedDialect + ")";
        }
        if (!normalizedDriver.isBlank()) {
            return normalizedDriver;
        }
        if (!normalizedDialect.isBlank()) {
            return normalizedDialect;
        }
        return "Unbekannt";
    }

    private String firstNonBlank(String ... values) {
        if (values == null) {
            return "";
        }
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            String normalized = this.normalizeText(value);
            if (!normalized.isBlank()) {
                return normalized;
            }
            ++n2;
        }
        return "";
    }

    private String normalizeText(String value) {
        return value == null ? "" : value.trim();
    }

    private static final class Resolution {
        private final DBSEntity table;
        private final DBCExecutionContext executionContext;
        private final String fqn;
        private final String databaseType;

        private Resolution(DBSEntity table, DBCExecutionContext executionContext, String fqn, String databaseType) {
            this.table = table;
            this.executionContext = executionContext;
            this.fqn = fqn;
            this.databaseType = databaseType == null || databaseType.isBlank() ? "Unbekannt" : databaseType;
        }

        private static Resolution unresolved() {
            return new Resolution(null, null, "", "Unbekannt");
        }
    }
}

