/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.context;

import ch.so.agi.dbeaver.ai.context.TableDdlExtractor;
import ch.so.agi.dbeaver.ai.model.ResolvedTable;
import java.util.LinkedHashMap;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;

public final class DBeaverTableDdlExtractor
implements TableDdlExtractor {
    private static final Log LOG = Log.getLog(DBeaverTableDdlExtractor.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public String extractDdl(ResolvedTable resolvedTable) throws Exception {
        void entity;
        Object object = resolvedTable.nativeTable();
        if (!(object instanceof DBSEntity)) {
            return this.fallbackByNameOnly(resolvedTable.fullyQualifiedName());
        }
        DBSEntity dBSEntity = (DBSEntity)object;
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        String ddl = null;
        try {
            ddl = DBStructUtils.generateObjectDDL((DBRProgressMonitor)monitor, (DBSObject)entity, new LinkedHashMap(), (boolean)true);
        }
        catch (Exception ex) {
            LOG.debug((Object)"generateObjectDDL failed, trying getTableDDL fallback", (Throwable)ex);
        }
        if (ddl == null || ddl.isBlank()) {
            try {
                ddl = DBStructUtils.getTableDDL((DBRProgressMonitor)monitor, (DBSEntity)entity, new LinkedHashMap(), (boolean)true);
            }
            catch (Exception ex) {
                LOG.debug((Object)"getTableDDL failed, using metadata fallback", (Throwable)ex);
            }
        }
        if (ddl != null && !ddl.isBlank()) {
            return ddl.trim();
        }
        return this.fallbackFromMetadata((DBSEntity)entity, resolvedTable.fullyQualifiedName(), (DBRProgressMonitor)monitor);
    }

    private String fallbackFromMetadata(DBSEntity entity, String fallbackName, DBRProgressMonitor monitor) {
        String tableName = fallbackName;
        try {
            tableName = DBUtils.getQuotedIdentifier((DBSObject)entity);
        }
        catch (Exception exception) {}
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(tableName).append(" (\n");
        try {
            List attributes = entity.getAttributes(monitor);
            if (attributes == null || attributes.isEmpty()) {
                sb.append("  -- no columns available\n");
            } else {
                int i = 0;
                while (i < attributes.size()) {
                    DBSEntityAttribute attr = (DBSEntityAttribute)attributes.get(i);
                    if (i > 0) {
                        sb.append(",\n");
                    }
                    String colName = this.safeColumnName(attr);
                    String typeName = attr.getFullTypeName();
                    if (typeName == null || typeName.isBlank()) {
                        typeName = attr.getTypeName();
                    }
                    if (typeName == null || typeName.isBlank()) {
                        typeName = "UNKNOWN";
                    }
                    sb.append("  ").append(colName).append(' ').append(typeName);
                    if (attr.isRequired()) {
                        sb.append(" NOT NULL");
                    }
                    ++i;
                }
                sb.append('\n');
            }
        }
        catch (DBException ex) {
            sb.append("  -- metadata unavailable: ").append(ex.getMessage()).append('\n');
        }
        sb.append(");");
        return sb.toString();
    }

    private String fallbackByNameOnly(String fqn) {
        return "CREATE TABLE " + fqn + " (\n  -- metadata unavailable\n);";
    }

    private String safeColumnName(DBSEntityAttribute attr) {
        try {
            return DBUtils.getQuotedIdentifier((DBSObject)attr);
        }
        catch (Exception exception) {
            return attr.getName();
        }
    }
}

