/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.chat;

import ch.so.agi.dbeaver.ai.chat.ChatRequestOptions;
import ch.so.agi.dbeaver.ai.chat.ChatSession;
import ch.so.agi.dbeaver.ai.chat.ChatUiListener;
import ch.so.agi.dbeaver.ai.context.ContextAssembler;
import ch.so.agi.dbeaver.ai.context.ContextEnricher;
import ch.so.agi.dbeaver.ai.llm.ContextAwarePromptComposer;
import ch.so.agi.dbeaver.ai.llm.LlmClient;
import ch.so.agi.dbeaver.ai.llm.LlmRequest;
import ch.so.agi.dbeaver.ai.llm.LlmResponseListener;
import ch.so.agi.dbeaver.ai.llm.StreamingHandle;
import ch.so.agi.dbeaver.ai.mention.MentionParser;
import ch.so.agi.dbeaver.ai.model.ChatMessage;
import ch.so.agi.dbeaver.ai.model.ContextBundle;
import ch.so.agi.dbeaver.ai.model.TableReference;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ChatController {
    private final ChatSession session;
    private final MentionParser mentionParser;
    private final ContextEnricher contextEnricher;
    private final ContextAssembler contextAssembler;
    private final ContextAwarePromptComposer promptComposer;
    private final LlmClient llmClient;
    private final AtomicReference<StreamingHandle> activeStream = new AtomicReference();

    public ChatController(ChatSession session, MentionParser mentionParser, ContextEnricher contextEnricher, ContextAssembler contextAssembler, ContextAwarePromptComposer promptComposer, LlmClient llmClient) {
        this.session = Objects.requireNonNull(session, "session");
        this.mentionParser = Objects.requireNonNull(mentionParser, "mentionParser");
        this.contextEnricher = Objects.requireNonNull(contextEnricher, "contextEnricher");
        this.contextAssembler = Objects.requireNonNull(contextAssembler, "contextAssembler");
        this.promptComposer = Objects.requireNonNull(promptComposer, "promptComposer");
        this.llmClient = Objects.requireNonNull(llmClient, "llmClient");
    }

    public void cancelActiveRequest() {
        StreamingHandle handle = this.activeStream.getAndSet(null);
        if (handle != null) {
            handle.cancel();
        }
    }

    public void send(String systemPrompt, String userPrompt, ChatRequestOptions options, final ChatUiListener listener) {
        Objects.requireNonNull(listener, "listener");
        Objects.requireNonNull(options, "options");
        this.cancelActiveRequest();
        List<ChatMessage> historyBeforeCurrent = this.session.recentHistory(options.historySize());
        listener.onBeforeSend(userPrompt);
        this.session.addUser(userPrompt);
        List<TableReference> references = this.mentionParser.parseReferences(userPrompt);
        ContextBundle contextBundle = this.contextEnricher.build(references, options.maxReferencedTables(), options.sampleRowLimit(), options.maxColumnsPerSample(), options.includeDdl(), options.includeSampleRows());
        ContextBundle boundedContext = this.contextAssembler.truncateToBudget(contextBundle, options.maxContextTokens());
        String promptBlock = this.contextAssembler.toPromptBlock(boundedContext);
        listener.onContextBuilt(boundedContext, promptBlock);
        for (String warning : boundedContext.warnings()) {
            listener.onWarning(warning);
        }
        String composedUserPrompt = this.promptComposer.composeUserPrompt(userPrompt, promptBlock);
        LlmRequest llmRequest = new LlmRequest(systemPrompt, composedUserPrompt, promptBlock, historyBeforeCurrent);
        final StringBuilder assistantBuffer = new StringBuilder();
        StreamingHandle handle = this.llmClient.stream(llmRequest, new LlmResponseListener(){

            @Override
            public void onPartialText(String textChunk) {
                assistantBuffer.append(textChunk);
                listener.onAssistantPartial(textChunk);
            }

            @Override
            public void onComplete(String finalText) {
                ChatController.this.activeStream.set(null);
                String effectiveText = finalText == null || finalText.isBlank() ? assistantBuffer.toString() : finalText;
                ChatController.this.session.addAssistant(effectiveText);
                listener.onAssistantComplete(effectiveText);
            }

            @Override
            public void onError(Throwable error) {
                ChatController.this.activeStream.set(null);
                listener.onError("LLM request failed", error);
            }
        });
        this.activeStream.set(handle);
    }
}

