/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.config;

import ch.so.agi.dbeaver.ai.config.AiSettings;
import ch.so.agi.dbeaver.ai.config.LlmLogMode;
import java.io.IOException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public final class AiSettingsService {
    private static final Log LOG = Log.getLog(AiSettingsService.class);

    public AiSettings loadSettings() {
        DBPPreferenceStore store = this.preferenceStore();
        return new AiSettings(this.getPreferenceString(store, "ch.so.agi.dbeaver.ai.baseUrl", "https://api.openai.com/v1"), this.getPreferenceString(store, "ch.so.agi.dbeaver.ai.model", "gpt-4o-mini"), this.getPreferenceString(store, "ch.so.agi.dbeaver.ai.systemPrompt", "Du bist ein Datenbank-Assistent und hilfst prim\u00e4r beim Entwerfen, Debuggen und Optimieren herausfordernder SQL-Abfragen. Antworte immer auf Deutsch. Wenn du eine SQL-Abfrage lieferst, MUSS sie in einem ```sql```-Codeblock stehen. Zu jeder SQL-Abfrage MUSS eine kurze Erkl\u00e4rung mitgeliefert werden (Zweck, zentrale Join-/Filter-/Aggregationslogik, Annahmen). Nutze bereitgestellten Tabellenkontext (DDL und Sample Rows) vorrangig und nenne fehlende Informationen explizit."), this.getPreferenceInt(store, "ch.so.agi.dbeaver.ai.sampleRowLimit", 5), this.getPreferenceInt(store, "ch.so.agi.dbeaver.ai.maxReferencedTables", 8), this.getPreferenceInt(store, "ch.so.agi.dbeaver.ai.maxColumnsPerSample", 30), this.getPreferenceBoolean(store, "ch.so.agi.dbeaver.ai.includeDdl", true), this.getPreferenceBoolean(store, "ch.so.agi.dbeaver.ai.includeSampleRows", true), this.getPreferenceInt(store, "ch.so.agi.dbeaver.ai.historySize", 12), this.getPreferenceInt(store, "ch.so.agi.dbeaver.ai.maxContextTokens", 4000), this.getPreferenceInt(store, "ch.so.agi.dbeaver.ai.mentionProposalLimit", 40), this.parseLlmLogMode(this.getPreferenceString(store, "ch.so.agi.dbeaver.ai.llmLogMode", AiSettings.DEFAULT_LLM_LOG_MODE.name())), this.getPreferenceBoolean(store, "ch.so.agi.dbeaver.ai.langchainHttpLogging", false), this.parseDoubleOrDefault(store.getString("ch.so.agi.dbeaver.ai.temperature"), 0.0));
    }

    private String getPreferenceString(DBPPreferenceStore store, String key, String defaultValue) {
        String value = store.getString(key);
        return value == null || value.isBlank() ? defaultValue : value.trim();
    }

    private int getPreferenceInt(DBPPreferenceStore store, String key, int defaultValue) {
        int value = store.getInt(key);
        return value == 0 ? defaultValue : value;
    }

    private boolean getPreferenceBoolean(DBPPreferenceStore store, String key, boolean defaultValue) {
        String stringValue = store.getString(key);
        if (stringValue == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(stringValue.trim());
    }

    public void saveSettings(AiSettings settings) {
        DBPPreferenceStore store = this.preferenceStore();
        store.setValue("ch.so.agi.dbeaver.ai.baseUrl", settings.baseUrl());
        store.setValue("ch.so.agi.dbeaver.ai.model", settings.model());
        store.setValue("ch.so.agi.dbeaver.ai.systemPrompt", settings.systemPrompt());
        store.setValue("ch.so.agi.dbeaver.ai.sampleRowLimit", settings.sampleRowLimit());
        store.setValue("ch.so.agi.dbeaver.ai.maxReferencedTables", settings.maxReferencedTables());
        store.setValue("ch.so.agi.dbeaver.ai.maxColumnsPerSample", settings.maxColumnsPerSample());
        store.setValue("ch.so.agi.dbeaver.ai.includeDdl", settings.includeDdl());
        store.setValue("ch.so.agi.dbeaver.ai.includeSampleRows", settings.includeSampleRows());
        store.setValue("ch.so.agi.dbeaver.ai.historySize", settings.historySize());
        store.setValue("ch.so.agi.dbeaver.ai.maxContextTokens", settings.maxContextTokens());
        store.setValue("ch.so.agi.dbeaver.ai.mentionProposalLimit", settings.mentionProposalLimit());
        store.setValue("ch.so.agi.dbeaver.ai.llmLogMode", settings.llmLogMode().name());
        store.setValue("ch.so.agi.dbeaver.ai.langchainHttpLogging", settings.langchainHttpLogging());
        store.setValue("ch.so.agi.dbeaver.ai.temperature", Double.toString(settings.temperature()));
        try {
            store.save();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to save AI preference store", (Throwable)e);
        }
    }

    public String loadApiToken() {
        DBSSecretController controller;
        block3: {
            try {
                controller = this.secretController();
                if (controller != null) break block3;
                return "";
            }
            catch (DBException e) {
                LOG.warn((Object)"Failed to load API token from secret storage", (Throwable)e);
                return "";
            }
        }
        String token = controller.getPrivateSecretValue("ch.so.agi.dbeaver.ai.openai.apiToken");
        return token == null ? "" : token;
    }

    public void saveApiToken(String token) {
        try {
            DBSSecretController controller = this.secretController();
            if (controller == null) {
                LOG.warn((Object)"No secret controller available, API token not persisted");
                return;
            }
            controller.setPrivateSecretValue("ch.so.agi.dbeaver.ai.openai.apiToken", token == null ? "" : token);
            controller.flushChanges();
        }
        catch (DBException e) {
            LOG.warn((Object)"Failed to store API token in secret storage", (Throwable)e);
        }
    }

    public boolean hasApiToken() {
        return !this.loadApiToken().isBlank();
    }

    private DBPPreferenceStore preferenceStore() {
        return DBWorkbench.getPlatform().getPreferenceStore();
    }

    private DBSSecretController secretController() throws DBException {
        DBPProject project;
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        if (workspace != null && (project = workspace.getActiveProject()) != null) {
            return DBSSecretController.getProjectSecretController((DBPProject)project);
        }
        return DBSSecretController.getGlobalSecretController();
    }

    private double parseDoubleOrDefault(String value, double fallback) {
        if (value == null || value.isBlank()) {
            return fallback;
        }
        try {
            return Double.parseDouble(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    private LlmLogMode parseLlmLogMode(String value) {
        return LlmLogMode.fromPreferenceValue(value);
    }
}

