/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.config;

import ch.so.agi.dbeaver.ai.chat.ChatRequestOptions;
import ch.so.agi.dbeaver.ai.config.LlmLogMode;
import java.time.Duration;
import java.util.Objects;

public final class AiSettings {
    public static final String DEFAULT_BASE_URL = "https://api.openai.com/v1";
    public static final String DEFAULT_MODEL = "gpt-4o-mini";
    public static final String DEFAULT_SYSTEM_PROMPT = "Du bist ein Datenbank-Assistent und hilfst prim\u00e4r beim Entwerfen, Debuggen und Optimieren herausfordernder SQL-Abfragen. Antworte immer auf Deutsch. Wenn du eine SQL-Abfrage lieferst, MUSS sie in einem ```sql```-Codeblock stehen. Zu jeder SQL-Abfrage MUSS eine kurze Erkl\u00e4rung mitgeliefert werden (Zweck, zentrale Join-/Filter-/Aggregationslogik, Annahmen). Nutze bereitgestellten Tabellenkontext (DDL und Sample Rows) vorrangig und nenne fehlende Informationen explizit.";
    public static final boolean DEFAULT_INCLUDE_DDL = true;
    public static final boolean DEFAULT_INCLUDE_SAMPLE_ROWS = true;
    public static final int DEFAULT_MENTION_PROPOSAL_LIMIT = 40;
    public static final LlmLogMode DEFAULT_LLM_LOG_MODE = LlmLogMode.METADATA;
    public static final boolean DEFAULT_LANGCHAIN_HTTP_LOGGING = false;
    private final String baseUrl;
    private final String model;
    private final String systemPrompt;
    private final int sampleRowLimit;
    private final int maxReferencedTables;
    private final int maxColumnsPerSample;
    private final boolean includeDdl;
    private final boolean includeSampleRows;
    private final int historySize;
    private final int maxContextTokens;
    private final int mentionProposalLimit;
    private final LlmLogMode llmLogMode;
    private final boolean langchainHttpLogging;
    private final double temperature;

    public AiSettings(String baseUrl, String model, String systemPrompt, int sampleRowLimit, int maxReferencedTables, int maxColumnsPerSample, boolean includeDdl, boolean includeSampleRows, int historySize, int maxContextTokens, int mentionProposalLimit, LlmLogMode llmLogMode, boolean langchainHttpLogging, double temperature) {
        this.baseUrl = AiSettings.normalizeOrDefault(baseUrl, DEFAULT_BASE_URL);
        this.model = AiSettings.normalizeOrDefault(model, DEFAULT_MODEL);
        this.systemPrompt = AiSettings.normalizeOrDefault(systemPrompt, DEFAULT_SYSTEM_PROMPT);
        this.sampleRowLimit = Math.max(1, sampleRowLimit);
        this.maxReferencedTables = Math.max(1, maxReferencedTables);
        this.maxColumnsPerSample = Math.max(1, maxColumnsPerSample);
        this.includeDdl = includeDdl;
        this.includeSampleRows = includeSampleRows;
        this.historySize = Math.max(0, historySize);
        this.maxContextTokens = Math.max(100, maxContextTokens);
        this.mentionProposalLimit = Math.max(1, mentionProposalLimit);
        this.llmLogMode = llmLogMode == null ? DEFAULT_LLM_LOG_MODE : llmLogMode;
        this.langchainHttpLogging = langchainHttpLogging;
        this.temperature = AiSettings.clampTemperature(temperature);
    }

    private static String normalizeOrDefault(String value, String fallback) {
        if (value == null || value.isBlank()) {
            return fallback;
        }
        return value.trim();
    }

    private static double clampTemperature(double value) {
        if (Double.isNaN(value)) {
            return 0.0;
        }
        return Math.max(0.0, Math.min(2.0, value));
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String model() {
        return this.model;
    }

    public String systemPrompt() {
        return this.systemPrompt;
    }

    public int sampleRowLimit() {
        return this.sampleRowLimit;
    }

    public int maxReferencedTables() {
        return this.maxReferencedTables;
    }

    public int maxColumnsPerSample() {
        return this.maxColumnsPerSample;
    }

    public boolean includeDdl() {
        return this.includeDdl;
    }

    public boolean includeSampleRows() {
        return this.includeSampleRows;
    }

    public int historySize() {
        return this.historySize;
    }

    public int maxContextTokens() {
        return this.maxContextTokens;
    }

    public int mentionProposalLimit() {
        return this.mentionProposalLimit;
    }

    public LlmLogMode llmLogMode() {
        return this.llmLogMode;
    }

    public boolean langchainHttpLogging() {
        return this.langchainHttpLogging;
    }

    public double temperature() {
        return this.temperature;
    }

    public Duration timeout() {
        return Duration.ofSeconds(90L);
    }

    public ChatRequestOptions toChatRequestOptions() {
        return new ChatRequestOptions(this.maxReferencedTables, this.sampleRowLimit, this.maxColumnsPerSample, this.includeDdl, this.includeSampleRows, this.maxContextTokens, this.historySize);
    }

    public AiSettings withTemperature(double value) {
        return new AiSettings(this.baseUrl, this.model, this.systemPrompt, this.sampleRowLimit, this.maxReferencedTables, this.maxColumnsPerSample, this.includeDdl, this.includeSampleRows, this.historySize, this.maxContextTokens, this.mentionProposalLimit, this.llmLogMode, this.langchainHttpLogging, value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseUrl, this.model, this.systemPrompt, this.sampleRowLimit, this.maxReferencedTables, this.maxColumnsPerSample, this.includeDdl, this.includeSampleRows, this.historySize, this.maxContextTokens, this.mentionProposalLimit, this.llmLogMode, this.langchainHttpLogging, this.temperature});
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AiSettings)) {
            return false;
        }
        AiSettings aiSettings = (AiSettings)obj;
        return this.sampleRowLimit == other.sampleRowLimit && this.maxReferencedTables == other.maxReferencedTables && this.maxColumnsPerSample == other.maxColumnsPerSample && this.includeDdl == other.includeDdl && this.includeSampleRows == other.includeSampleRows && this.historySize == other.historySize && this.maxContextTokens == other.maxContextTokens && this.mentionProposalLimit == other.mentionProposalLimit && this.llmLogMode == other.llmLogMode && this.langchainHttpLogging == other.langchainHttpLogging && Double.compare(this.temperature, other.temperature) == 0 && this.baseUrl.equals(other.baseUrl) && this.model.equals(other.model) && this.systemPrompt.equals(other.systemPrompt);
    }
}

