/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.mention;

import ch.so.agi.dbeaver.ai.model.TableReference;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public final class DBeaverMentionCatalog {
    private static final Log LOG = Log.getLog(DBeaverMentionCatalog.class);
    private static final int MAX_TRAVERSAL_DEPTH = 4;
    private static final int DEFAULT_MAX_CANDIDATES = 500;

    public List<TableReference> loadCandidates() {
        return this.loadCandidates(500);
    }

    public List<TableReference> loadCandidates(int maxCandidates) {
        int safeMax = Math.max(1, maxCandidates);
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        if (workspace == null) {
            return List.of();
        }
        LinkedHashMap<String, TableReference> dedup = new LinkedHashMap<String, TableReference>();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        DBPProject active = workspace.getActiveProject();
        this.appendProjectReferences(active, dedup, (DBRProgressMonitor)monitor, safeMax);
        if (dedup.size() >= safeMax) {
            return new ArrayList<TableReference>(dedup.values());
        }
        for (DBPProject project : workspace.getProjects()) {
            if (Objects.equals(project, active)) continue;
            this.appendProjectReferences(project, dedup, (DBRProgressMonitor)monitor, safeMax);
            if (dedup.size() >= safeMax) break;
        }
        return new ArrayList<TableReference>(dedup.values());
    }

    private void appendProjectReferences(DBPProject project, Map<String, TableReference> dedup, DBRProgressMonitor monitor, int maxCandidates) {
        if (project == null) {
            return;
        }
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        if (registry == null) {
            return;
        }
        List dataSources = registry.getDataSources();
        if (dataSources == null) {
            return;
        }
        for (DBPDataSourceContainer dsContainer : dataSources) {
            DBPDataSource dataSource;
            if (dedup.size() >= maxCandidates) {
                return;
            }
            if (!dsContainer.isConnected() || !((dataSource = dsContainer.getDataSource()) instanceof DBSObjectContainer)) continue;
            DBSObjectContainer root = (DBSObjectContainer)dataSource;
            String datasourceName = dsContainer.getName();
            this.appendReferencesFromRoot(root, datasourceName, dedup, monitor, maxCandidates);
        }
    }

    private void appendReferencesFromRoot(DBSObjectContainer root, String datasourceName, Map<String, TableReference> dedup, DBRProgressMonitor monitor, int maxCandidates) {
        ArrayDeque<NodeWithDepth> stack = new ArrayDeque<NodeWithDepth>();
        HashSet<CallSite> visited = new HashSet<CallSite>();
        stack.push(new NodeWithDepth(root, 0));
        while (!stack.isEmpty() && dedup.size() < maxCandidates) {
            String key;
            NodeWithDepth entry = (NodeWithDepth)stack.pop();
            DBSObjectContainer container = entry.container;
            if (entry.depth > 4 || !visited.add((CallSite)((Object)(key = container.getClass().getName() + "@" + System.identityHashCode(container))))) continue;
            try {
                for (DBSObject child : container.getChildren(monitor)) {
                    if (child instanceof DBSEntity) {
                        DBSEntity entity = (DBSEntity)child;
                        String schema = entity.getParentObject() == null ? "default" : this.safeName(entity.getParentObject().getName());
                        String table = this.safeName(entity.getName());
                        TableReference ref = new TableReference(this.safeName(datasourceName), schema, table, "#" + this.safeName(datasourceName) + "." + schema + "." + table);
                        dedup.putIfAbsent(ref.canonicalId(), ref);
                        if (dedup.size() >= maxCandidates) {
                            return;
                        }
                    }
                    if (!(child instanceof DBSObjectContainer)) continue;
                    DBSObjectContainer nested = (DBSObjectContainer)child;
                    stack.push(new NodeWithDepth(nested, entry.depth + 1));
                }
            }
            catch (Exception ex) {
                LOG.debug((Object)"Failed to traverse metadata for mention candidates", (Throwable)ex);
            }
        }
    }

    private String safeName(String value) {
        if (value == null || value.isBlank()) {
            return "unknown";
        }
        return value;
    }

    private static final class NodeWithDepth {
        private final DBSObjectContainer container;
        private final int depth;

        private NodeWithDepth(DBSObjectContainer container, int depth) {
            this.container = container;
            this.depth = depth;
        }
    }
}

