/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.model;

import ch.so.agi.dbeaver.ai.model.TableReference;
import ch.so.agi.dbeaver.ai.model.TableSampleRow;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class TableContext {
    private final TableReference reference;
    private final String fullyQualifiedName;
    private final String databaseType;
    private final String ddl;
    private final String sampleSql;
    private final List<TableSampleRow> sampleRows;

    public TableContext(TableReference reference, String fullyQualifiedName, String databaseType, String ddl, String sampleSql, List<TableSampleRow> sampleRows) {
        this.reference = Objects.requireNonNull(reference, "reference");
        this.fullyQualifiedName = Objects.requireNonNull(fullyQualifiedName, "fullyQualifiedName");
        this.databaseType = databaseType == null || databaseType.isBlank() ? "Unbekannt" : databaseType.trim();
        this.ddl = Objects.requireNonNull(ddl, "ddl");
        this.sampleSql = Objects.requireNonNull(sampleSql, "sampleSql");
        this.sampleRows = List.copyOf((Collection)Objects.requireNonNull(sampleRows, "sampleRows"));
    }

    public TableReference reference() {
        return this.reference;
    }

    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String databaseType() {
        return this.databaseType;
    }

    public String ddl() {
        return this.ddl;
    }

    public String sampleSql() {
        return this.sampleSql;
    }

    public List<TableSampleRow> sampleRows() {
        return Collections.unmodifiableList(this.sampleRows);
    }
}

