/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.config;

import ch.so.agi.dbeaver.ai.config.AiSettings;
import ch.so.agi.dbeaver.ai.config.AiSettingsService;
import ch.so.agi.dbeaver.ai.config.LlmLogMode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class AiPreferencePageMain
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final AiSettingsService settingsService = new AiSettingsService();
    private Text baseUrlText;
    private Text modelText;
    private Text systemPromptText;
    private Text apiTokenText;
    private Text sampleRowLimitText;
    private Text maxReferencedTablesText;
    private Text maxColumnsPerSampleText;
    private Text historySizeText;
    private Text maxContextTokensText;
    private Text mentionProposalLimitText;
    private Text mentionCandidateLimitText;
    private Text temperatureText;
    private Combo llmLogModeCombo;
    private Button includeDdlButton;
    private Button includeSampleRowsButton;
    private Button langchainHttpLoggingButton;
    private Button clearTokenButton;
    private Label tokenStatusLabel;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout(2, false));
        root.setLayoutData((Object)new GridData(4, 4, true, true));
        this.baseUrlText = this.createLabeledText(root, "Base URL", 2048);
        this.modelText = this.createLabeledText(root, "Model", 2048);
        Label promptLabel = new Label(root, 0);
        promptLabel.setText("System Prompt");
        promptLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.systemPromptText = new Text(root, 2626);
        GridData promptGd = new GridData(4, 128, true, false);
        promptGd.heightHint = 120;
        promptGd.widthHint = 700;
        this.systemPromptText.setLayoutData((Object)promptGd);
        this.apiTokenText = this.createLabeledText(root, "OpenAI API Token", 0x400800);
        this.apiTokenText.setMessage("Leer lassen, um gespeicherten Token beizubehalten");
        this.tokenStatusLabel = new Label(root, 0);
        this.tokenStatusLabel.setText("");
        GridData statusGd = new GridData(4, 0x1000000, true, false);
        statusGd.horizontalSpan = 2;
        this.tokenStatusLabel.setLayoutData((Object)statusGd);
        this.clearTokenButton = new Button(root, 32);
        this.clearTokenButton.setText("Gespeicherten API Token l\u00f6schen");
        GridData clearGd = new GridData(4, 0x1000000, true, false);
        clearGd.horizontalSpan = 2;
        this.clearTokenButton.setLayoutData((Object)clearGd);
        this.includeDdlButton = new Button(root, 32);
        this.includeDdlButton.setText("DDL im Kontext mitsenden");
        GridData includeDdlGd = new GridData(4, 0x1000000, true, false);
        includeDdlGd.horizontalSpan = 2;
        this.includeDdlButton.setLayoutData((Object)includeDdlGd);
        this.includeSampleRowsButton = new Button(root, 32);
        this.includeSampleRowsButton.setText("Sample Rows im Kontext mitsenden");
        GridData includeSampleRowsGd = new GridData(4, 0x1000000, true, false);
        includeSampleRowsGd.horizontalSpan = 2;
        this.includeSampleRowsButton.setLayoutData((Object)includeSampleRowsGd);
        this.sampleRowLimitText = this.createLabeledText(root, "Sample Row Limit", 2048);
        this.maxReferencedTablesText = this.createLabeledText(root, "Max Referenced Tables", 2048);
        this.maxColumnsPerSampleText = this.createLabeledText(root, "Max Columns per Sample", 2048);
        this.historySizeText = this.createLabeledText(root, "Chat History Size", 2048);
        this.maxContextTokensText = this.createLabeledText(root, "Max Context Tokens", 2048);
        this.mentionProposalLimitText = this.createLabeledText(root, "Autocomplete Proposal Limit", 2048);
        this.mentionCandidateLimitText = this.createLabeledText(root, "Autocomplete Candidate Scan Limit", 2048);
        this.temperatureText = this.createLabeledText(root, "Temperature (0.0 - 2.0)", 2048);
        this.llmLogModeCombo = this.createLabeledCombo(root, "LLM Logging", new String[]{"OFF", "METADATA", "FULL"});
        this.langchainHttpLoggingButton = new Button(root, 32);
        this.langchainHttpLoggingButton.setText("LangChain HTTP Logging (Request/Response)");
        GridData langchainLoggingGd = new GridData(4, 0x1000000, true, false);
        langchainLoggingGd.horizontalSpan = 2;
        this.langchainHttpLoggingButton.setLayoutData((Object)langchainLoggingGd);
        Label loggingHintLabel = new Label(root, 64);
        loggingHintLabel.setText("Hinweis: LLM Logging = FULL schreibt vollst\u00e4ndige Prompt- und Antworttexte ins Error Log.");
        GridData loggingHintGd = new GridData(4, 0x1000000, true, false);
        loggingHintGd.horizontalSpan = 2;
        loggingHintGd.widthHint = 700;
        loggingHintLabel.setLayoutData((Object)loggingHintGd);
        this.loadFromSettings(this.settingsService.loadSettings());
        this.updateTokenStatus();
        return root;
    }

    public boolean performOk() {
        String enteredToken;
        AiSettings settings = this.readFromForm();
        this.settingsService.saveSettings(settings);
        if (this.clearTokenButton.getSelection()) {
            this.settingsService.saveApiToken("");
        }
        String string = enteredToken = this.apiTokenText.getText() == null ? "" : this.apiTokenText.getText().trim();
        if (!enteredToken.isEmpty()) {
            this.settingsService.saveApiToken(enteredToken);
            this.apiTokenText.setText("");
        }
        this.updateTokenStatus();
        return true;
    }

    protected void performDefaults() {
        this.loadFromSettings(new AiSettings("https://api.openai.com/v1", "gpt-4o-mini", "Du bist ein Datenbank-Assistent und hilfst prim\u00e4r beim Entwerfen, Debuggen und Optimieren herausfordernder SQL-Abfragen. Antworte immer auf Deutsch. Wenn du eine SQL-Abfrage lieferst, MUSS sie in einem ```sql```-Codeblock stehen. Zu jeder SQL-Abfrage MUSS eine kurze Erkl\u00e4rung mitgeliefert werden (Zweck, zentrale Join-/Filter-/Aggregationslogik, Annahmen). Nutze bereitgestellten Tabellenkontext (DDL und Sample Rows) vorrangig und nenne fehlende Informationen explizit.", 5, 8, 30, true, true, 12, 4000, 40, 100000, AiSettings.DEFAULT_LLM_LOG_MODE, false, 0.0));
        this.clearTokenButton.setSelection(false);
        this.apiTokenText.setText("");
        super.performDefaults();
    }

    private void loadFromSettings(AiSettings settings) {
        this.baseUrlText.setText(settings.baseUrl());
        this.modelText.setText(settings.model());
        this.systemPromptText.setText(settings.systemPrompt());
        this.sampleRowLimitText.setText(Integer.toString(settings.sampleRowLimit()));
        this.maxReferencedTablesText.setText(Integer.toString(settings.maxReferencedTables()));
        this.maxColumnsPerSampleText.setText(Integer.toString(settings.maxColumnsPerSample()));
        this.historySizeText.setText(Integer.toString(settings.historySize()));
        this.maxContextTokensText.setText(Integer.toString(settings.maxContextTokens()));
        this.mentionProposalLimitText.setText(Integer.toString(settings.mentionProposalLimit()));
        this.mentionCandidateLimitText.setText(Integer.toString(settings.mentionCandidateLimit()));
        this.temperatureText.setText(Double.toString(settings.temperature()));
        this.llmLogModeCombo.setText(settings.llmLogMode().name());
        this.includeDdlButton.setSelection(settings.includeDdl());
        this.includeSampleRowsButton.setSelection(settings.includeSampleRows());
        this.langchainHttpLoggingButton.setSelection(settings.langchainHttpLogging());
    }

    private AiSettings readFromForm() {
        return new AiSettings(this.safeTrim(this.baseUrlText.getText(), "https://api.openai.com/v1"), this.safeTrim(this.modelText.getText(), "gpt-4o-mini"), this.safeTrim(this.systemPromptText.getText(), "Du bist ein Datenbank-Assistent und hilfst prim\u00e4r beim Entwerfen, Debuggen und Optimieren herausfordernder SQL-Abfragen. Antworte immer auf Deutsch. Wenn du eine SQL-Abfrage lieferst, MUSS sie in einem ```sql```-Codeblock stehen. Zu jeder SQL-Abfrage MUSS eine kurze Erkl\u00e4rung mitgeliefert werden (Zweck, zentrale Join-/Filter-/Aggregationslogik, Annahmen). Nutze bereitgestellten Tabellenkontext (DDL und Sample Rows) vorrangig und nenne fehlende Informationen explizit."), this.parseIntOrDefault(this.sampleRowLimitText.getText(), 5), this.parseIntOrDefault(this.maxReferencedTablesText.getText(), 8), this.parseIntOrDefault(this.maxColumnsPerSampleText.getText(), 30), this.includeDdlButton.getSelection(), this.includeSampleRowsButton.getSelection(), this.parseIntOrDefault(this.historySizeText.getText(), 12), this.parseIntOrDefault(this.maxContextTokensText.getText(), 4000), this.parseIntOrDefault(this.mentionProposalLimitText.getText(), 40), this.parseIntOrDefault(this.mentionCandidateLimitText.getText(), 100000), this.parseLlmLogMode(this.llmLogModeCombo.getText()), this.langchainHttpLoggingButton.getSelection(), this.parseDoubleOrDefault(this.temperatureText.getText(), 0.0));
    }

    private void updateTokenStatus() {
        this.tokenStatusLabel.setText(this.settingsService.hasApiToken() ? "API Token ist im Secret Store gespeichert" : "Kein API Token gespeichert");
        this.tokenStatusLabel.getParent().layout(true, true);
    }

    private Text createLabeledText(Composite parent, String label, int style) {
        Label l = new Label(parent, 0);
        l.setText(label);
        Text t = new Text(parent, style);
        t.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return t;
    }

    private Combo createLabeledCombo(Composite parent, String label, String[] values) {
        Label l = new Label(parent, 0);
        l.setText(label);
        Combo combo = new Combo(parent, 12);
        combo.setItems(values);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (values.length > 0) {
            combo.select(0);
        }
        return combo;
    }

    private int parseIntOrDefault(String text, int fallback) {
        try {
            return Integer.parseInt(text.trim());
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    private double parseDoubleOrDefault(String text, double fallback) {
        try {
            return Double.parseDouble(text.trim());
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    private String safeTrim(String text, String fallback) {
        if (text == null || text.isBlank()) {
            return fallback;
        }
        return text.trim();
    }

    private LlmLogMode parseLlmLogMode(String value) {
        return LlmLogMode.fromPreferenceValue(value);
    }
}

