/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.context;

import ch.so.agi.dbeaver.ai.context.SampleRowsCollector;
import ch.so.agi.dbeaver.ai.context.SensitiveDataMasker;
import ch.so.agi.dbeaver.ai.context.TableDdlExtractor;
import ch.so.agi.dbeaver.ai.context.TableReferenceResolver;
import ch.so.agi.dbeaver.ai.model.ContextBundle;
import ch.so.agi.dbeaver.ai.model.ResolvedTable;
import ch.so.agi.dbeaver.ai.model.ResolvedTableResult;
import ch.so.agi.dbeaver.ai.model.TableContext;
import ch.so.agi.dbeaver.ai.model.TableReference;
import ch.so.agi.dbeaver.ai.model.TableSampleRow;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public final class ContextEnricher {
    private final TableReferenceResolver resolver;
    private final TableDdlExtractor ddlExtractor;
    private final SampleRowsCollector sampleRowsCollector;
    private final SensitiveDataMasker sensitiveDataMasker;

    public ContextEnricher(TableReferenceResolver resolver, TableDdlExtractor ddlExtractor, SampleRowsCollector sampleRowsCollector, SensitiveDataMasker sensitiveDataMasker) {
        this.resolver = resolver;
        this.ddlExtractor = ddlExtractor;
        this.sampleRowsCollector = sampleRowsCollector;
        this.sensitiveDataMasker = sensitiveDataMasker;
    }

    public ContextBundle build(List<TableReference> references, int maxReferencedTables, int sampleRowLimit, int maxColumns, boolean includeDdl, boolean includeSampleRows) {
        ResolvedTableResult resolved = this.resolver.resolve(references);
        ArrayList<TableContext> tableContexts = new ArrayList<TableContext>();
        ArrayList<String> warnings = new ArrayList<String>(resolved.warnings());
        int max = Math.max(0, maxReferencedTables);
        int count = 0;
        for (ResolvedTable table : resolved.resolvedTables()) {
            if (count >= max) {
                warnings.add("Maximum number of referenced tables reached: " + max);
                break;
            }
            Object ddl = "<disabled>";
            if (includeDdl) {
                try {
                    ddl = this.ddlExtractor.extractDdl(table);
                }
                catch (Exception ex) {
                    ddl = "-- DDL unavailable: " + ex.getMessage();
                    warnings.add("DDL extraction failed for " + table.fullyQualifiedName() + ": " + ex.getMessage());
                }
            }
            String sampleSql = this.sampleRowsCollector.createSampleQueryText(table, sampleRowLimit);
            List<TableSampleRow> rows = List.of();
            if (includeSampleRows) {
                try {
                    rows = this.maskRows(this.sampleRowsCollector.collect(table, sampleRowLimit, maxColumns));
                }
                catch (Exception ex) {
                    warnings.add("Sample row collection failed for " + table.fullyQualifiedName() + ": " + ex.getMessage());
                }
            }
            tableContexts.add(new TableContext(table.reference(), table.fullyQualifiedName(), table.databaseType(), (String)ddl, sampleSql, rows));
            ++count;
        }
        return new ContextBundle(tableContexts, false, warnings);
    }

    private List<TableSampleRow> maskRows(List<TableSampleRow> rows) {
        ArrayList<TableSampleRow> result = new ArrayList<TableSampleRow>(rows.size());
        for (TableSampleRow row : rows) {
            LinkedHashMap<String, String> copied = new LinkedHashMap<String, String>(row.values());
            this.sensitiveDataMasker.maskRow(copied);
            result.add(new TableSampleRow(copied));
        }
        return result;
    }
}

