/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.llm;

import ch.so.agi.dbeaver.ai.config.LlmLogMode;
import ch.so.agi.dbeaver.ai.llm.LlmClient;
import ch.so.agi.dbeaver.ai.llm.LlmPayloadLogger;
import ch.so.agi.dbeaver.ai.llm.LlmRequest;
import ch.so.agi.dbeaver.ai.llm.LlmResponseListener;
import ch.so.agi.dbeaver.ai.llm.StreamingHandle;
import ch.so.agi.dbeaver.ai.model.ChatMessage;
import ch.so.agi.dbeaver.ai.model.ChatRole;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.PartialResponse;
import dev.langchain4j.model.chat.response.PartialResponseContext;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jkiss.dbeaver.Log;

public final class LangChain4jOpenAiClient
implements LlmClient {
    private static final Log LOG = Log.getLog(LangChain4jOpenAiClient.class);
    private final String baseUrl;
    private final String apiKey;
    private final String modelName;
    private final double temperature;
    private final Duration timeout;
    private final LlmLogMode llmLogMode;
    private final boolean langchainHttpLogging;
    private final LlmPayloadLogger payloadLogger = new LlmPayloadLogger();

    public LangChain4jOpenAiClient(String baseUrl, String apiKey, String modelName, double temperature, Duration timeout, LlmLogMode llmLogMode, boolean langchainHttpLogging) {
        this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl");
        this.apiKey = Objects.requireNonNull(apiKey, "apiKey");
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.temperature = temperature;
        this.timeout = Objects.requireNonNull(timeout, "timeout");
        this.llmLogMode = llmLogMode == null ? LlmLogMode.METADATA : llmLogMode;
        this.langchainHttpLogging = langchainHttpLogging;
    }

    @Override
    public StreamingHandle stream(LlmRequest request, final LlmResponseListener listener) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(listener, "listener");
        OpenAiStreamingChatModel model = OpenAiStreamingChatModel.builder().baseUrl(this.baseUrl).apiKey(this.apiKey).modelName(this.modelName).temperature(Double.valueOf(this.temperature)).timeout(this.timeout).logRequests(Boolean.valueOf(this.langchainHttpLogging)).logResponses(Boolean.valueOf(this.langchainHttpLogging)).build();
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(SystemMessage.from((String)request.systemPrompt()));
        for (ChatMessage msg : request.history()) {
            if (msg.role() == ChatRole.USER) {
                messages.add(UserMessage.from((String)msg.text()));
                continue;
            }
            if (msg.role() != ChatRole.ASSISTANT) continue;
            messages.add(AiMessage.from((String)msg.text()));
        }
        messages.add(UserMessage.from((String)request.userPrompt()));
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        final long startedAtNanos = System.nanoTime();
        if (this.llmLogMode != LlmLogMode.OFF) {
            LOG.info((Object)("LLM request started (provider=langchain4j-openai, model=" + this.modelName + ", baseUrl=" + this.baseUrl + ", historyMessages=" + request.history().size() + ", userPromptChars=" + request.userPrompt().length() + ", contextChars=" + request.contextBlock().length() + ", langchainHttpLogging=" + this.langchainHttpLogging + ")"));
        }
        if (this.llmLogMode == LlmLogMode.FULL) {
            this.logParts("LLM request payload", this.payloadLogger.formatRequestParts(request));
        }
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        final AtomicReference modelHandleRef = new AtomicReference();
        final StringBuilder partialText = new StringBuilder();
        model.chat(chatRequest, new StreamingChatResponseHandler(){

            public void onPartialResponse(PartialResponse partialResponse, PartialResponseContext context) {
                modelHandleRef.compareAndSet(null, context.streamingHandle());
                if (cancelled.get()) {
                    context.streamingHandle().cancel();
                    return;
                }
                String chunk = partialResponse.text();
                partialText.append(chunk);
                listener.onPartialText(chunk);
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                String text;
                if (cancelled.get()) {
                    return;
                }
                String string = text = completeResponse.aiMessage() == null ? "" : completeResponse.aiMessage().text();
                if (text == null || text.isEmpty()) {
                    text = partialText.toString();
                }
                long durationMs = (System.nanoTime() - startedAtNanos) / 1000000L;
                if (LangChain4jOpenAiClient.this.llmLogMode != LlmLogMode.OFF) {
                    LOG.info((Object)("LLM response completed (chars=" + text.length() + ", durationMs=" + durationMs + ")"));
                }
                if (LangChain4jOpenAiClient.this.llmLogMode == LlmLogMode.FULL) {
                    LangChain4jOpenAiClient.this.logParts("LLM response payload", LangChain4jOpenAiClient.this.payloadLogger.formatResponseParts(text));
                }
                listener.onComplete(text);
            }

            public void onError(Throwable error) {
                if (cancelled.get()) {
                    return;
                }
                long durationMs = (System.nanoTime() - startedAtNanos) / 1000000L;
                LOG.error((Object)("LLM request failed (durationMs=" + durationMs + ")"), error);
                listener.onError(error);
            }
        });
        return () -> {
            cancelled.set(true);
            dev.langchain4j.model.chat.response.StreamingHandle handle = (dev.langchain4j.model.chat.response.StreamingHandle)modelHandleRef.get();
            if (handle != null) {
                handle.cancel();
            }
        };
    }

    private void logParts(String prefix, List<String> parts) {
        int i = 0;
        while (i < parts.size()) {
            LOG.info((Object)(prefix + " [part " + (i + 1) + "/" + parts.size() + "]\n" + parts.get(i)));
            ++i;
        }
    }
}

