/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.mention;

import ch.so.agi.dbeaver.ai.mention.MentionProposal;
import ch.so.agi.dbeaver.ai.model.TableReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;

public final class MentionProposalProvider {
    private final Supplier<List<TableReference>> candidatesSupplier;

    public MentionProposalProvider(Supplier<List<TableReference>> candidatesSupplier) {
        this.candidatesSupplier = candidatesSupplier;
    }

    public List<MentionProposal> suggest(String prefix) {
        String typedPrefix = prefix == null ? "" : prefix;
        List<TableReference> candidates = this.candidatesSupplier.get();
        if (typedPrefix.indexOf(46) < 0) {
            return this.sorted(this.suggestDatasources(candidates, typedPrefix));
        }
        String datasource = this.findBestDatasource(candidates, typedPrefix);
        if (datasource == null) {
            return this.sorted(this.suggestDatasources(candidates, typedPrefix));
        }
        if (typedPrefix.length() == datasource.length()) {
            return this.sorted(this.suggestDatasources(candidates, typedPrefix));
        }
        if (typedPrefix.charAt(datasource.length()) != '.') {
            return this.sorted(this.suggestDatasources(candidates, typedPrefix));
        }
        String schemaAndMaybeTable = typedPrefix.substring(datasource.length() + 1);
        String schema = this.findBestSchema(candidates, datasource, schemaAndMaybeTable);
        if (schema == null || !this.matchesCompletedSegment(schemaAndMaybeTable, schema)) {
            return this.sorted(this.suggestSchemas(candidates, typedPrefix, datasource, schemaAndMaybeTable));
        }
        String tablePrefix = schemaAndMaybeTable.substring(schema.length() + 1);
        return this.sorted(this.suggestTables(candidates, typedPrefix, datasource, schema, tablePrefix));
    }

    private List<MentionProposal> suggestDatasources(List<TableReference> candidates, String typedPrefix) {
        LinkedHashSet<String> datasources = new LinkedHashSet<String>();
        for (TableReference candidate : candidates) {
            if (!this.startsWithIgnoreCase(candidate.datasourceName(), typedPrefix)) continue;
            datasources.add(candidate.datasourceName());
        }
        ArrayList<MentionProposal> proposals = new ArrayList<MentionProposal>();
        for (String datasource : datasources) {
            proposals.add(this.buildProposal("#" + datasource, datasource, typedPrefix));
        }
        return proposals;
    }

    private List<MentionProposal> suggestSchemas(List<TableReference> candidates, String fullPrefix, String datasource, String schemaPrefix) {
        LinkedHashSet<String> schemas = new LinkedHashSet<String>();
        for (TableReference candidate : candidates) {
            if (!this.equalsIgnoreCase(candidate.datasourceName(), datasource) || !this.startsWithIgnoreCase(candidate.schemaName(), schemaPrefix)) continue;
            schemas.add(candidate.schemaName());
        }
        ArrayList<MentionProposal> proposals = new ArrayList<MentionProposal>();
        for (String schema : schemas) {
            String completion = datasource + "." + schema;
            proposals.add(this.buildProposal(schema, completion, fullPrefix));
        }
        return proposals;
    }

    private List<MentionProposal> suggestTables(List<TableReference> candidates, String fullPrefix, String datasource, String schema, String tablePrefix) {
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        for (TableReference candidate : candidates) {
            if (!this.equalsIgnoreCase(candidate.datasourceName(), datasource) || !this.equalsIgnoreCase(candidate.schemaName(), schema) || !this.startsWithIgnoreCase(candidate.tableName(), tablePrefix)) continue;
            tables.add(candidate.tableName());
        }
        ArrayList<MentionProposal> proposals = new ArrayList<MentionProposal>();
        for (String table : tables) {
            String completion = datasource + "." + schema + "." + table;
            proposals.add(this.buildProposal(table, completion, fullPrefix));
        }
        return proposals;
    }

    private MentionProposal buildProposal(String display, String completion, String typedPrefix) {
        String insert = this.suffixForCompletion(completion, typedPrefix);
        return new MentionProposal(display, insert);
    }

    private String suffixForCompletion(String completion, String typedPrefix) {
        if (typedPrefix == null || typedPrefix.isEmpty()) {
            return completion;
        }
        int prefixLength = typedPrefix.length();
        if (prefixLength <= completion.length() && completion.regionMatches(true, 0, typedPrefix, 0, prefixLength)) {
            return completion.substring(prefixLength);
        }
        return completion;
    }

    private String findBestDatasource(List<TableReference> candidates, String fullPrefix) {
        LinkedHashSet<String> datasources = new LinkedHashSet<String>();
        for (TableReference candidate : candidates) {
            datasources.add(candidate.datasourceName());
        }
        return this.findBestCompletedSegment(datasources, fullPrefix);
    }

    private String findBestSchema(List<TableReference> candidates, String datasource, String remainder) {
        LinkedHashSet<String> schemas = new LinkedHashSet<String>();
        for (TableReference candidate : candidates) {
            if (!this.equalsIgnoreCase(candidate.datasourceName(), datasource)) continue;
            schemas.add(candidate.schemaName());
        }
        return this.findBestCompletedSegment(schemas, remainder);
    }

    private String findBestCompletedSegment(Set<String> values, String fullPrefix) {
        String best = null;
        for (String value : values) {
            if (value == null || value.isBlank() || !this.matchesCompletedSegment(fullPrefix, value) || best != null && value.length() <= best.length()) continue;
            best = value;
        }
        return best;
    }

    private boolean matchesCompletedSegment(String fullPrefix, String segment) {
        if (fullPrefix == null || segment == null) {
            return false;
        }
        int segmentLength = segment.length();
        if (fullPrefix.length() <= segmentLength) {
            return false;
        }
        return fullPrefix.regionMatches(true, 0, segment, 0, segmentLength) && fullPrefix.charAt(segmentLength) == '.';
    }

    private List<MentionProposal> sorted(List<MentionProposal> proposals) {
        proposals.sort(Comparator.comparing(MentionProposal::displayText));
        return proposals;
    }

    private boolean equalsIgnoreCase(String left, String right) {
        if (left == null || right == null) {
            return false;
        }
        return left.equalsIgnoreCase(right);
    }

    private boolean startsWithIgnoreCase(String value, String prefix) {
        String safeValue = value == null ? "" : value;
        String safePrefix = prefix == null ? "" : prefix;
        return safeValue.toLowerCase(Locale.ROOT).startsWith(safePrefix.toLowerCase(Locale.ROOT));
    }
}

