/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ai.ui;

import ch.so.agi.dbeaver.ai.chat.ChatController;
import ch.so.agi.dbeaver.ai.chat.ChatSession;
import ch.so.agi.dbeaver.ai.chat.ChatUiListener;
import ch.so.agi.dbeaver.ai.config.AiSettings;
import ch.so.agi.dbeaver.ai.config.AiSettingsService;
import ch.so.agi.dbeaver.ai.context.ContextAssembler;
import ch.so.agi.dbeaver.ai.context.ContextEnricher;
import ch.so.agi.dbeaver.ai.context.DBeaverSampleRowsCollector;
import ch.so.agi.dbeaver.ai.context.DBeaverTableDdlExtractor;
import ch.so.agi.dbeaver.ai.context.DBeaverTableReferenceResolver;
import ch.so.agi.dbeaver.ai.context.PromptBudgetEstimator;
import ch.so.agi.dbeaver.ai.context.SensitiveDataMasker;
import ch.so.agi.dbeaver.ai.llm.ContextAwarePromptComposer;
import ch.so.agi.dbeaver.ai.llm.LangChain4jOpenAiClient;
import ch.so.agi.dbeaver.ai.mention.DBeaverMentionCatalog;
import ch.so.agi.dbeaver.ai.mention.MentionParser;
import ch.so.agi.dbeaver.ai.mention.MentionProposal;
import ch.so.agi.dbeaver.ai.mention.MentionProposalProvider;
import ch.so.agi.dbeaver.ai.mention.MentionTriggerDetector;
import ch.so.agi.dbeaver.ai.model.ContextBundle;
import ch.so.agi.dbeaver.ai.model.TableReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public final class AiChatViewPart
extends ViewPart {
    private static final Log LOG = Log.getLog(AiChatViewPart.class);
    public static final String VIEW_ID = "ch.so.agi.dbeaver.ai.views.chat";
    private final AiSettingsService settingsService = new AiSettingsService();
    private final ChatSession chatSession = new ChatSession();
    private final MentionParser mentionParser = new MentionParser();
    private final MentionTriggerDetector mentionTriggerDetector = new MentionTriggerDetector();
    private final DBeaverMentionCatalog mentionCatalog = new DBeaverMentionCatalog();
    private final ContextEnricher contextEnricher = new ContextEnricher(new DBeaverTableReferenceResolver(), new DBeaverTableDdlExtractor(), new DBeaverSampleRowsCollector(), new SensitiveDataMasker());
    private final ContextAssembler contextAssembler = new ContextAssembler(new PromptBudgetEstimator());
    private final ContextAwarePromptComposer promptComposer = new ContextAwarePromptComposer();
    private Text transcriptText;
    private Text inputText;
    private Button sendButton;
    private Button stopButton;
    private Label statusLabel;
    private volatile List<TableReference> mentionCandidates = List.of();
    private volatile boolean mentionCandidatesDirty = true;
    private final Set<DBPDataSourceRegistry> registeredDataSourceRegistries = new HashSet<DBPDataSourceRegistry>();
    private final Object mentionListenerLock = new Object();
    private DBPPreferenceStore preferenceStore;
    private final DBPEventListener mentionDataSourceListener = event -> {
        if (event == null) {
            return;
        }
        DBPEvent.Action action = event.getAction();
        if (action == DBPEvent.Action.AFTER_CONNECT || action == DBPEvent.Action.OBJECT_ADD || action == DBPEvent.Action.OBJECT_REMOVE || action == DBPEvent.Action.OBJECT_UPDATE) {
            this.markMentionCandidatesDirty();
        }
    };
    private final DBPPreferenceListener mentionPreferenceListener = event -> {
        if (event != null && "ch.so.agi.dbeaver.ai.mentionCandidateLimit".equals(event.getProperty())) {
            this.markMentionCandidatesDirty();
        }
    };
    private MentionProposalProvider mentionProposalProvider;
    private volatile ChatController activeController;

    public void createPartControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout(1, false));
        root.setLayoutData((Object)new GridData(4, 4, true, true));
        this.transcriptText = new Text(root, 2634);
        this.transcriptText.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite inputRow = new Composite(root, 0);
        inputRow.setLayout((Layout)new GridLayout(4, false));
        inputRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inputText = new Text(inputRow, 2626);
        GridData inputGd = new GridData(4, 0x1000000, true, false);
        inputGd.heightHint = 56;
        this.inputText.setLayoutData((Object)inputGd);
        this.sendButton = new Button(inputRow, 8);
        this.sendButton.setText("Send");
        this.stopButton = new Button(inputRow, 8);
        this.stopButton.setText("Stop");
        this.stopButton.setEnabled(false);
        Button refreshMentionsButton = new Button(inputRow, 8);
        refreshMentionsButton.setText("Refresh #");
        this.statusLabel = new Label(root, 0);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.statusLabel.setText("Ready");
        this.mentionProposalProvider = new MentionProposalProvider(this::currentMentionCandidates);
        this.installMentionRefreshHooks();
        this.installMentionAutocomplete();
        this.sendButton.addListener(13, e -> this.sendPrompt());
        this.stopButton.addListener(13, e -> this.stopPrompt());
        refreshMentionsButton.addListener(13, e -> this.refreshMentions());
        this.inputText.addListener(1, e -> {
            if ((e.stateMask & SWT.MOD1) != 0 && (e.keyCode == 13 || e.keyCode == 0x1000050)) {
                this.sendPrompt();
                e.doit = false;
            }
        });
        this.appendLine("AI Chat bereit. Verwende #datasource.schema.table f\u00fcr Tabellenkontext.");
    }

    public void setFocus() {
        this.registerDataSourceListeners();
        this.refreshMentionsIfDirty();
        if (this.inputText != null && !this.inputText.isDisposed()) {
            this.inputText.setFocus();
        }
    }

    public void dispose() {
        this.stopPrompt();
        this.disposeMentionRefreshHooks();
        super.dispose();
    }

    public void prefillPrompt(String text) {
        if (this.inputText == null || this.inputText.isDisposed()) {
            return;
        }
        this.inputText.setText(text == null ? "" : text);
        this.inputText.setFocus();
        this.inputText.setSelection(this.inputText.getText().length());
    }

    private void sendPrompt() {
        ChatController controller;
        String userPrompt;
        String string = userPrompt = this.inputText.getText() == null ? "" : this.inputText.getText().trim();
        if (userPrompt.isBlank()) {
            return;
        }
        AiSettings settings = this.settingsService.loadSettings();
        String apiToken = this.settingsService.loadApiToken();
        if (apiToken.isBlank()) {
            this.setStatus("Kein API-Token gesetzt. Bitte in den Preferences konfigurieren.");
            return;
        }
        this.inputText.setText("");
        LangChain4jOpenAiClient llmClient = new LangChain4jOpenAiClient(settings.baseUrl(), apiToken, settings.model(), settings.temperature(), settings.timeout(), settings.llmLogMode(), settings.langchainHttpLogging());
        this.activeController = controller = new ChatController(this.chatSession, this.mentionParser, this.contextEnricher, this.contextAssembler, this.promptComposer, llmClient);
        controller.send(settings.systemPrompt(), userPrompt, settings.toChatRequestOptions(), new ViewChatUiListener());
    }

    private void stopPrompt() {
        ChatController controller = this.activeController;
        if (controller != null) {
            controller.cancelActiveRequest();
        }
        this.activeController = null;
        this.ui(() -> {
            this.sendButton.setEnabled(true);
            this.stopButton.setEnabled(false);
            this.setStatus("Anfrage gestoppt");
        });
    }

    private void refreshMentions() {
        this.reloadMentionCandidates(true);
    }

    private synchronized List<TableReference> currentMentionCandidates() {
        this.reloadMentionCandidates(false);
        return this.mentionCandidates;
    }

    private void refreshMentionsIfDirty() {
        if (this.mentionCandidatesDirty) {
            this.reloadMentionCandidates(false);
        }
    }

    private synchronized void reloadMentionCandidates(boolean force) {
        if (!force && !this.mentionCandidatesDirty) {
            return;
        }
        this.registerDataSourceListeners();
        int mentionCandidateLimit = this.settingsService.loadSettings().mentionCandidateLimit();
        this.mentionCandidates = this.mentionCatalog.loadCandidates(mentionCandidateLimit);
        this.mentionCandidatesDirty = false;
        this.setStatus("Autocomplete aktualisiert: " + this.mentionCandidates.size() + " Tabellen referenzierbar");
    }

    private void installMentionRefreshHooks() {
        this.registerDataSourceListeners();
        this.preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (this.preferenceStore != null) {
            this.preferenceStore.addPropertyChangeListener(this.mentionPreferenceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeMentionRefreshHooks() {
        if (this.preferenceStore != null) {
            this.preferenceStore.removePropertyChangeListener(this.mentionPreferenceListener);
            this.preferenceStore = null;
        }
        Object object = this.mentionListenerLock;
        synchronized (object) {
            for (DBPDataSourceRegistry registry : this.registeredDataSourceRegistries) {
                try {
                    registry.removeDataSourceListener(this.mentionDataSourceListener);
                }
                catch (Exception ex) {
                    LOG.debug((Object)"Failed to remove datasource listener for mention refresh", (Throwable)ex);
                }
            }
            this.registeredDataSourceRegistries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDataSourceListeners() {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        if (workspace == null) {
            return;
        }
        boolean addedRegistry = false;
        Object object = this.mentionListenerLock;
        synchronized (object) {
            for (DBPProject project : workspace.getProjects()) {
                DBPDataSourceRegistry registry;
                if (project == null || (registry = project.getDataSourceRegistry()) == null || this.registeredDataSourceRegistries.contains(registry)) continue;
                try {
                    registry.addDataSourceListener(this.mentionDataSourceListener);
                    this.registeredDataSourceRegistries.add(registry);
                    addedRegistry = true;
                }
                catch (Exception ex) {
                    LOG.debug((Object)"Failed to register datasource listener for mention refresh", (Throwable)ex);
                }
            }
        }
        if (addedRegistry) {
            this.markMentionCandidatesDirty();
        }
    }

    private void markMentionCandidatesDirty() {
        this.mentionCandidatesDirty = true;
    }

    private void installMentionAutocomplete() {
        IContentProposalProvider provider = (contents, position) -> {
            if (!this.mentionTriggerDetector.isInMentionContext(contents, position)) {
                return new IContentProposal[0];
            }
            String prefix = this.mentionTriggerDetector.currentMentionPrefix(contents, position);
            List<MentionProposal> proposals = this.mentionProposalProvider.suggest(prefix);
            int proposalLimit = this.settingsService.loadSettings().mentionProposalLimit();
            int shown = Math.min(proposalLimit, proposals.size());
            this.setStatus(shown + "/" + proposals.size() + " Treffer");
            return (IContentProposal[])proposals.stream().limit(proposalLimit).map(p -> new ContentProposal(p.insertText(), p.displayText(), null, p.insertText().length())).toArray(IContentProposal[]::new);
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.inputText, (IControlContentAdapter)new TextContentAdapter(), provider, KeyStroke.getInstance((int)SWT.MOD1, (int)32), new char[]{'#', '.'});
        adapter.setProposalAcceptanceStyle(1);
        adapter.setPropagateKeys(true);
        adapter.setAutoActivationDelay(80);
    }

    private void appendLine(String text) {
        this.ui(() -> {
            String existing = this.transcriptText.getText();
            String next = existing.isBlank() ? text : existing + "\n" + text;
            this.transcriptText.setText(next);
            this.transcriptText.setSelection(this.transcriptText.getText().length());
        });
    }

    private void appendText(String text) {
        this.ui(() -> {
            this.transcriptText.append(text);
            this.transcriptText.setSelection(this.transcriptText.getText().length());
        });
    }

    private void setStatus(String status) {
        this.ui(() -> this.statusLabel.setText(status == null ? "" : status));
    }

    private void ui(Runnable runnable) {
        Display display;
        Display display2 = display = this.getSite() == null ? Display.getDefault() : this.getSite().getShell().getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            display.asyncExec(() -> {
                if (this.transcriptText == null || this.transcriptText.isDisposed()) {
                    return;
                }
                runnable.run();
            });
        }
    }

    private final class ViewChatUiListener
    implements ChatUiListener {
        private ViewChatUiListener() {
        }

        @Override
        public void onBeforeSend(String userPrompt) {
            AiChatViewPart.this.ui(() -> {
                AiChatViewPart.this.sendButton.setEnabled(false);
                AiChatViewPart.this.stopButton.setEnabled(true);
            });
            AiChatViewPart.this.appendLine("You> " + userPrompt);
            AiChatViewPart.this.appendLine("AI> ");
            AiChatViewPart.this.setStatus("Anfrage wird verarbeitet...");
        }

        @Override
        public void onContextBuilt(ContextBundle contextBundle, String promptBlock) {
            AiChatViewPart.this.setStatus("Kontext aufgebaut: " + contextBundle.tableContexts().size() + " Tabelle(n)");
        }

        @Override
        public void onAssistantPartial(String chunk) {
            AiChatViewPart.this.appendText(chunk);
        }

        @Override
        public void onAssistantComplete(String finalText) {
            AiChatViewPart.this.appendText("\n");
            AiChatViewPart.this.ui(() -> {
                AiChatViewPart.this.sendButton.setEnabled(true);
                AiChatViewPart.this.stopButton.setEnabled(false);
            });
            AiChatViewPart.this.setStatus("Antwort vollst\u00e4ndig");
            AiChatViewPart.this.activeController = null;
        }

        @Override
        public void onWarning(String warning) {
            AiChatViewPart.this.appendLine("[Warnung] " + warning);
        }

        @Override
        public void onError(String message, Throwable error) {
            AiChatViewPart.this.appendLine("[Fehler] " + message + ": " + (error == null ? "<unknown>" : error.getMessage()));
            AiChatViewPart.this.ui(() -> {
                AiChatViewPart.this.sendButton.setEnabled(true);
                AiChatViewPart.this.stopButton.setEnabled(false);
            });
            AiChatViewPart.this.setStatus("Fehler bei der Anfrage");
            AiChatViewPart.this.activeController = null;
        }
    }
}

