/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ili2pg.handlers;

import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2pg.PgMain;
import ch.so.agi.dbeaver.ili2pg.jobs.Ili2pgJob;
import ch.so.agi.dbeaver.ili2pg.log.Log;
import ch.so.agi.dbeaver.ili2pg.ui.Ili2pgExportDialog;
import ch.so.agi.dbeaver.ili2pg.ui.Ili2pgImportDialog;
import ch.so.agi.dbeaver.ili2pg.ui.Ili2pgImportSchemaDialog;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class Ili2pgHandler
extends AbstractHandler {
    private static final String CMD_SCHEMA_IMPORT = "ch.so.agi.dbeaver.ili2pg.commands.importSchema";
    private static final String CMD_DATA_IMPORT = "ch.so.agi.dbeaver.ili2pg.commands.importData";
    private static final String CMD_EXPORT = "ch.so.agi.dbeaver.ili2pg.commands.exportSchema";
    private static final String CMD_EXPORT_OPTS = "ch.so.agi.dbeaver.ili2pg.commands.exportSchemaWithOptions";
    private static final String CMD_VALIDATE = "ch.so.agi.dbeaver.ili2pg.commands.validateSchema";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Action action = Action.from(event.getCommand().getId());
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection) || ((IStructuredSelection)sel).isEmpty()) {
            return null;
        }
        Object first = ((IStructuredSelection)sel).getFirstElement();
        if (action == Action.SCHEMA_IMPORT) {
            DBSInstance database = this.extractDatabase(first);
            if (database == null) {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                MessageDialog.openInformation((Shell)window.getShell(), (String)"", (String)"Not a PostgreSQL database.");
                return null;
            }
            Log.info("Database: " + String.valueOf(database));
            Ili2pgImportSchemaDialog dlg = new Ili2pgImportSchemaDialog(shell);
            if (dlg.open() == 0) {
                String ini = dlg.getIniPath();
                String ilidata = dlg.getIliDataRef();
                String schema = dlg.getTargetSchema();
                Config settings = this.createConfig();
                if (ini != null) {
                    settings.setMetaConfigFile(ini);
                } else {
                    settings.setMetaConfigFile(ilidata);
                }
                settings.setDbschema(schema);
                new Ili2pgJob(shell, (DBSObject)database, settings, Ili2pgJob.Mode.SCHEMA_IMPORT).schedule();
            }
            return null;
        }
        if (action == Action.IMPORT) {
            List<String> modelNames;
            DBSSchema schema = this.extractSchema(first);
            if (schema == null) {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                MessageDialog.openInformation((Shell)window.getShell(), (String)"", (String)"Not a PostgreSQL schema.");
                return null;
            }
            Log.info("Schema: " + String.valueOf(schema));
            try {
                modelNames = this.loadModelNames(schema);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)"ili2pg", (String)("Failed to load model names: " + e.getMessage()));
                return null;
            }
            Log.info("modelNames: " + String.valueOf(modelNames));
            if (modelNames.isEmpty()) {
                MessageDialog.openInformation((Shell)shell, (String)"ili2pg", (String)("No rows in " + schema.getName() + ".t_ili2db_model (or table missing)."));
                return null;
            }
            Config settings = this.createConfig();
            Ili2pgImportDialog dlg = new Ili2pgImportDialog(shell, modelNames);
            if (dlg.open() != 0) {
                return null;
            }
            String modelName = this.sanitizeModelName(dlg.getSelectedModel());
            settings.setModels(modelName);
            if (dlg.isDisableValidation()) {
                settings.setValidation(false);
            }
            if (dlg.getDataset() != null) {
                settings.setDatasetName(dlg.getDataset());
            }
            if (dlg.getBaskets() != null) {
                settings.setBaskets(dlg.getBaskets());
            }
            if (dlg.getTopics() != null) {
                settings.setTopics(dlg.getTopics());
            }
            if (dlg.getTransferFilePath() != null) {
                settings.setXtffile(dlg.getTransferFilePath());
            }
            if (dlg.getExternalTransferRef() != null) {
                settings.setXtffile(dlg.getExternalTransferRef());
            }
            new Ili2pgJob(shell, (DBSObject)schema, settings, Ili2pgJob.Mode.IMPORT).schedule();
        } else {
            List<String> modelNames;
            DBSSchema schema = this.extractSchema(first);
            if (schema == null) {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                MessageDialog.openInformation((Shell)window.getShell(), (String)"", (String)"Not a PostgreSQL schema.");
                return null;
            }
            Log.info("Schema: " + String.valueOf(schema));
            try {
                modelNames = this.loadModelNames(schema);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)"ili2pg", (String)("Failed to load model names: " + e.getMessage()));
                return null;
            }
            Log.info("modelNames: " + String.valueOf(modelNames));
            if (modelNames.isEmpty()) {
                MessageDialog.openInformation((Shell)shell, (String)"ili2pg", (String)("No rows in " + schema.getName() + ".t_ili2db_model (or table missing)."));
                return null;
            }
            Config settings = this.createConfig();
            switch (action) {
                case EXPORT: 
                case VALIDATE: {
                    String chosenModel = null;
                    if (modelNames.size() > 1) {
                        ElementListSelectionDialog dlg = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                        dlg.setTitle("Select ili2pg model");
                        dlg.setMessage("Choose a model from schema: " + schema.getName());
                        dlg.setMultipleSelection(false);
                        dlg.setElements((Object[])modelNames.toArray(new String[0]));
                        if (dlg.open() != 0) {
                            return null;
                        }
                        chosenModel = (String)dlg.getFirstResult();
                    } else {
                        chosenModel = modelNames.get(0);
                    }
                    chosenModel = this.sanitizeModelName(chosenModel);
                    settings.setModels(chosenModel);
                    if (action == Action.EXPORT) {
                        new Ili2pgJob(shell, (DBSObject)schema, settings, Ili2pgJob.Mode.EXPORT).schedule();
                        break;
                    }
                    new Ili2pgJob(shell, (DBSObject)schema, settings, Ili2pgJob.Mode.VALIDATE).schedule();
                    break;
                }
                case EXPORT_WITH_OPTIONS: {
                    Ili2pgExportDialog dlg = new Ili2pgExportDialog(shell, schema.getName(), modelNames);
                    if (dlg.open() != 0) {
                        return null;
                    }
                    String modelName = this.sanitizeModelName(dlg.getSelectedModel());
                    settings.setModels(modelName);
                    if (dlg.isDisableValidation()) {
                        settings.setValidation(false);
                    }
                    if (dlg.getDatasets() != null) {
                        settings.setDatasetName(dlg.getDatasets());
                    }
                    if (dlg.getBaskets() != null) {
                        settings.setBaskets(dlg.getBaskets());
                    }
                    if (dlg.getTopics() != null) {
                        settings.setTopics(dlg.getTopics());
                    }
                    new Ili2pgJob(shell, (DBSObject)schema, settings, Ili2pgJob.Mode.EXPORT).schedule();
                }
            }
        }
        return null;
    }

    private Config createConfig() {
        Config settings = new Config();
        new PgMain().initConfig(settings);
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "ch.so.agi.dbeaver.ili2pg");
        String ilidir = store.getString("ilidir");
        if (!ilidir.isBlank()) {
            settings.setModeldir(ilidir);
        } else {
            settings.setModeldir("%ILI_DIR;http://models.interlis.ch/;%JAR_DIR");
        }
        return settings;
    }

    private String sanitizeModelName(String modelName) {
        if (modelName.contains("{")) {
            return modelName.substring(0, modelName.indexOf("{"));
        }
        return modelName;
    }

    private DBSSchema extractSchema(Object element) {
        if (element instanceof DBNDatabaseItem) {
            DBSObject obj;
            DBSObject p = obj = ((DBNDatabaseItem)element).getObject();
            while (p != null) {
                if (p instanceof PostgreSchema) {
                    return (DBSSchema)p;
                }
                p = p.getParentObject();
            }
        }
        return null;
    }

    private DBSInstance extractDatabase(Object element) {
        if (element instanceof DBNDatabaseItem) {
            DBSObject obj;
            DBSObject p = obj = ((DBNDatabaseItem)element).getObject();
            while (p != null) {
                if (p instanceof PostgreDatabase) {
                    return (DBSInstance)p;
                }
                p = p.getParentObject();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> loadModelNames(DBSSchema schema) throws SQLException, DBCException {
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        DBPDataSource ds = schema.getDataSource();
        String qSchema = DBUtils.getQuotedIdentifier((DBSObject)schema);
        String qTable = DBUtils.getQuotedIdentifier((DBPDataSource)ds, (String)"t_ili2db_model");
        String sql = "SELECT modelname, content FROM " + qSchema + "." + qTable + " ORDER BY modelname";
        LinkedHashSet<String> uniq = new LinkedHashSet<String>();
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)ds, (String)"Read INTERLIS model names");
            try {
                block19: {
                    JDBCPreparedStatement stmt = session.prepareStatement(sql);
                    try {
                        try (JDBCResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                String v = JDBCUtils.safeGetString((ResultSet)rs, (int)1);
                                String c = JDBCUtils.safeGetString((ResultSet)rs, (int)2);
                                if (v == null || v.isEmpty() || c.contains("CONTRACTED") || c.contains("TYPE") || c.contains("REFSYSTEM") || c.contains("SYMBOLOGY")) continue;
                                uniq.add(v);
                            }
                        }
                        if (stmt == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stmt == null) throw throwable;
                        stmt.close();
                        throw throwable;
                    }
                    stmt.close();
                }
                if (session == null) return new ArrayList<String>(uniq);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (session == null) throw throwable;
                session.close();
                throw throwable;
            }
            session.close();
            return new ArrayList<String>(uniq);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private static enum Action {
        SCHEMA_IMPORT,
        IMPORT,
        EXPORT,
        EXPORT_WITH_OPTIONS,
        VALIDATE;


        static Action from(String id) {
            if (Ili2pgHandler.CMD_EXPORT.equals(id)) {
                return EXPORT;
            }
            if (Ili2pgHandler.CMD_EXPORT_OPTS.equals(id)) {
                return EXPORT_WITH_OPTIONS;
            }
            if (Ili2pgHandler.CMD_VALIDATE.equals(id)) {
                return VALIDATE;
            }
            if (Ili2pgHandler.CMD_SCHEMA_IMPORT.equals(id)) {
                return SCHEMA_IMPORT;
            }
            if (Ili2pgHandler.CMD_DATA_IMPORT.equals(id)) {
                return IMPORT;
            }
            return EXPORT;
        }
    }
}

