/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ili2pg.ui;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Ili2pgImportSchemaDialog
extends TitleAreaDialog {
    private Text iniPathText;
    private Text ilidataText;
    private Text schemaNameText;
    private String iniPath;
    private String ilidataRef;
    private String targetSchema;

    public Ili2pgImportSchemaDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Import schema with ili2pg");
        this.setMessage("Provide either an INI file or an ilidata reference, and a target schema name.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).margins(10, 10).spacing(8, 8).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        new Label(container, 0).setText("INI file:");
        this.iniPathText = new Text(container, 2048);
        this.iniPathText.setMessage("Choose ili2pg .ini file\u2026");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.iniPathText);
        Button browse = new Button(container, 8);
        browse.setText("Browse\u2026");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Ili2pgImportSchemaDialog.this.getShell(), 4096);
                fd.setText("Select ili2pg INI file");
                fd.setFilterExtensions(new String[]{"*.ini", "*.*"});
                String sel = fd.open();
                if (sel != null) {
                    Ili2pgImportSchemaDialog.this.iniPathText.setText(sel);
                }
            }
        });
        new Label(container, 0).setText("ilidata reference:");
        this.ilidataText = new Text(container, 2048);
        this.ilidataText.setMessage("ilidata:my-dataset-or-resource");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.ilidataText);
        new Label(container, 0).setText("Target schema name:");
        this.schemaNameText = new Text(container, 2048);
        this.schemaNameText.setMessage("e.g. my_schema");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.schemaNameText);
        ModifyListener mod = e -> this.validate();
        this.iniPathText.addModifyListener(mod);
        this.ilidataText.addModifyListener(mod);
        this.schemaNameText.addModifyListener(mod);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getShell().setMinimumSize(560, 300);
        this.validate();
    }

    protected boolean isResizable() {
        return true;
    }

    private void validate() {
        String ini = this.iniPathText != null ? this.iniPathText.getText().trim() : "";
        String ili = this.ilidataText != null ? this.ilidataText.getText().trim() : "";
        String sch = this.schemaNameText != null ? this.schemaNameText.getText().trim() : "";
        String error = null;
        if (sch.isEmpty()) {
            error = "Please enter a target schema name.";
        } else if (!sch.matches("[A-Za-z_][A-Za-z0-9_]*")) {
            error = "Schema name must start with a letter or underscore and contain only letters, digits, or underscores.";
        } else if (ini.isEmpty() && ili.isEmpty()) {
            error = "Choose either an INI file or an ilidata reference.";
        } else if (!ini.isEmpty() && !ini.toLowerCase().endsWith(".ini")) {
            error = "The selected file must have the .ini extension.";
        } else if (!ili.isEmpty() && !ili.startsWith("ilidata:")) {
            error = "The ilidata reference must start with \"ilidata:\".";
        }
        this.setErrorMessage(error);
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(error == null);
        }
    }

    protected void okPressed() {
        this.iniPath = this.iniPathText.getText().isBlank() ? null : this.iniPathText.getText().trim();
        this.ilidataRef = this.ilidataText.getText().isBlank() ? null : this.ilidataText.getText().trim();
        this.targetSchema = this.schemaNameText.getText().trim();
        super.okPressed();
    }

    public String getIniPath() {
        return this.iniPath;
    }

    public String getIliDataRef() {
        return this.ilidataRef;
    }

    public String getTargetSchema() {
        return this.targetSchema;
    }
}

