/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ili2pg.ui;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Ili2pgImportDialog
extends TitleAreaDialog {
    private final List<String> modelNames;
    private ComboViewer modelCombo;
    private Text transferFileText;
    private Text externalFileText;
    private Button disableValidationBtn;
    private Text datasetText;
    private Text basketsText;
    private Text topicsText;
    private String selectedModel;
    private String transferFilePath;
    private String externalTransferRef;
    private boolean disableValidation;
    private String dataset;
    private String baskets;
    private String topics;

    public Ili2pgImportDialog(Shell parentShell, List<String> modelNames) {
        super(parentShell);
        this.modelNames = modelNames;
    }

    public void create() {
        super.create();
        this.setTitle("Import data with ili2pg");
        this.setMessage("Select a model, provide a local transfer file (.xtf/.xml/.itf) or an ilidata reference, and choose options.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).margins(10, 10).spacing(8, 8).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        new Label(container, 0).setText("Model:");
        this.modelCombo = new ComboViewer(container, 12);
        this.modelCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.modelCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.modelCombo.setInput(this.modelNames);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(320, -1).applyTo((Control)this.modelCombo.getCombo());
        if (!this.modelNames.isEmpty()) {
            this.modelCombo.setSelection((ISelection)new StructuredSelection((Object)this.modelNames.get(0)));
        }
        this.modelCombo.addSelectionChangedListener(e -> this.validateInputs());
        new Label(container, 0).setText("Transfer file:");
        this.transferFileText = new Text(container, 2048);
        this.transferFileText.setMessage("Select .xtf, .xml or .itf\u2026");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.transferFileText);
        Button browse = new Button(container, 8);
        browse.setText("Browse\u2026");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Ili2pgImportDialog.this.getShell(), 4096);
                fd.setText("Select Interlis transfer file");
                fd.setFilterExtensions(new String[]{"*.xtf;*.xml;*.itf", "*.xtf", "*.xml", "*.itf", "*.*"});
                String sel = fd.open();
                if (sel != null) {
                    Ili2pgImportDialog.this.transferFileText.setText(sel);
                }
            }
        });
        new Label(container, 0).setText("External transfer (ilidata):");
        this.externalFileText = new Text(container, 2048);
        this.externalFileText.setMessage("ilidata:my-dataset-or-resource");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.externalFileText);
        this.disableValidationBtn = new Button(container, 32);
        this.disableValidationBtn.setText("Disable validation");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.disableValidationBtn);
        new Label(container, 0).setText("Dataset:");
        this.datasetText = new Text(container, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.datasetText);
        new Label(container, 0).setText("Basket(s):");
        this.basketsText = new Text(container, 2048);
        this.basketsText.setMessage("e.g. basketId1, basketId2");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.basketsText);
        new Label(container, 0).setText("Topic(s):");
        this.topicsText = new Text(container, 2048);
        this.topicsText.setMessage("e.g. Model.TopicA, Model.TopicB");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.topicsText);
        ModifyListener mod = e -> this.validateInputs();
        this.transferFileText.addModifyListener(mod);
        this.externalFileText.addModifyListener(mod);
        this.datasetText.addModifyListener(mod);
        this.basketsText.addModifyListener(mod);
        this.topicsText.addModifyListener(mod);
        this.disableValidationBtn.addListener(13, e -> this.validateInputs());
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getShell().setMinimumSize(560, 360);
        this.validateInputs();
    }

    protected boolean isResizable() {
        return true;
    }

    private void validateInputs() {
        String local = this.transferFileText != null ? this.transferFileText.getText().trim() : "";
        String ext = this.externalFileText != null ? this.externalFileText.getText().trim() : "";
        StructuredSelection sel = this.modelCombo != null ? (IStructuredSelection)this.modelCombo.getSelection() : StructuredSelection.EMPTY;
        String error = null;
        if (this.modelNames == null || this.modelNames.isEmpty()) {
            error = "No models available.";
        } else if (sel.isEmpty()) {
            error = "Please select a model.";
        } else if (local.isEmpty() && ext.isEmpty()) {
            error = "Provide either a local transfer file or an ilidata reference.";
        } else if (!local.isEmpty() && !this.hasValidTransferExt(local)) {
            error = "Local file must end with .xtf, .xml, or .itf.";
        } else if (!ext.isEmpty() && !ext.startsWith("ilidata:")) {
            error = "External reference must start with \"ilidata:\".";
        }
        this.setErrorMessage(error);
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(error == null);
        }
    }

    private boolean hasValidTransferExt(String path) {
        String p = path.toLowerCase();
        return p.endsWith(".xtf") || p.endsWith(".xml") || p.endsWith(".itf");
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.modelCombo.getSelection();
        this.selectedModel = (String)sel.getFirstElement();
        this.transferFilePath = this.transferFileText.getText().isBlank() ? null : this.transferFileText.getText().trim();
        this.externalTransferRef = this.externalFileText.getText().isBlank() ? null : this.externalFileText.getText().trim();
        this.disableValidation = this.disableValidationBtn.getSelection();
        this.dataset = this.datasetText.getText().isBlank() ? null : this.datasetText.getText().trim();
        this.baskets = this.basketsText.getText().isBlank() ? null : this.basketsText.getText().trim();
        this.topics = this.topicsText.getText().isBlank() ? null : this.topicsText.getText().trim();
        super.okPressed();
    }

    public String getSelectedModel() {
        return this.selectedModel;
    }

    public String getTransferFilePath() {
        return this.transferFilePath;
    }

    public String getExternalTransferRef() {
        return this.externalTransferRef;
    }

    public boolean isDisableValidation() {
        return this.disableValidation;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getBaskets() {
        return this.baskets;
    }

    public String getTopics() {
        return this.topics;
    }
}

