/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ili2pg.ui;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Ili2pgExportDialog
extends TitleAreaDialog {
    private final String schemaName;
    private final List<String> modelNames;
    private ComboViewer existingModelCombo;
    private ComboViewer exportModelCombo;
    private Label exportModelLabel;
    private Button disableValidationBtn;
    private Button overwriteBtn;
    private Text datasetsText;
    private Text basketsText;
    private Text topicsText;
    private Text outputText;
    private String selectedModel;
    private String selectedExportModel;
    private boolean disableValidation;
    private boolean overwrite;
    private String datasets;
    private String baskets;
    private String topics;
    private String outputPath;

    public Ili2pgExportDialog(Shell parentShell, String schemaName, List<String> modelNames) {
        super(parentShell);
        this.schemaName = schemaName;
        this.modelNames = modelNames;
    }

    public void create() {
        super.create();
        this.setTitle("Export schema with ili2pg");
        this.setMessage("Schema: " + this.schemaName + " \u2014 choose a model and options.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).margins(10, 10).spacing(8, 8).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        new Label(container, 0).setText("Model in schema:");
        this.existingModelCombo = new ComboViewer(container, 12);
        this.existingModelCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.existingModelCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.existingModelCombo.setInput(this.modelNames);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(320, -1).applyTo((Control)this.existingModelCombo.getCombo());
        if (!this.modelNames.isEmpty()) {
            this.existingModelCombo.setSelection((ISelection)new StructuredSelection((Object)this.modelNames.get(0)));
        }
        this.existingModelCombo.addSelectionChangedListener(e -> this.validate());
        this.exportModelLabel = new Label(container, 0);
        this.exportModelLabel.setText("Export model:");
        this.exportModelCombo = new ComboViewer(container, 12);
        this.exportModelCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.exportModelCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.exportModelCombo.setInput(this.modelNames);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(320, -1).applyTo((Control)this.exportModelCombo.getCombo());
        if (!this.modelNames.isEmpty()) {
            this.exportModelCombo.setSelection((ISelection)new StructuredSelection((Object)this.modelNames.get(0)));
        }
        this.exportModelCombo.addSelectionChangedListener(e -> this.validate());
        boolean showExportModel = this.modelNames.size() >= 2;
        this.toggleExportModelVisibility(showExportModel);
        this.disableValidationBtn = new Button(container, 32);
        this.disableValidationBtn.setText("Disable validation");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.disableValidationBtn);
        this.disableValidationBtn.addListener(13, l -> this.validate());
        new Label(container, 0).setText("Dataset(s):");
        this.datasetsText = new Text(container, 2048);
        this.datasetsText.setMessage("e.g. dataset1;dataset2");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.datasetsText);
        new Label(container, 0).setText("Basket(s):");
        this.basketsText = new Text(container, 2048);
        this.basketsText.setMessage("e.g. basketId1;basketId2");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.basketsText);
        new Label(container, 0).setText("Topic(s):");
        this.topicsText = new Text(container, 2048);
        this.topicsText.setMessage("e.g. Model.TopicA;Model.TopicB");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.topicsText);
        return area;
    }

    private void toggleExportModelVisibility(boolean show) {
        this.exportModelLabel.setVisible(show);
        this.exportModelCombo.getCombo().setVisible(show);
        GridData gd1 = (GridData)this.exportModelLabel.getLayoutData();
        if (gd1 == null) {
            gd1 = new GridData();
            this.exportModelLabel.setLayoutData((Object)gd1);
        }
        gd1.exclude = !show;
        GridData gd2 = (GridData)this.exportModelCombo.getCombo().getLayoutData();
        if (gd2 == null) {
            gd2 = new GridData();
            this.exportModelCombo.getCombo().setLayoutData((Object)gd2);
        }
        gd2.exclude = !show;
        this.exportModelCombo.getCombo().setEnabled(show);
        this.exportModelCombo.getCombo().setToolTipText(show ? "" : "Only available when the schema contains two or more models.");
        this.exportModelLabel.getParent().layout(true, true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getShell().setMinimumSize(560, 480);
        this.validate();
    }

    protected boolean isResizable() {
        return true;
    }

    private void validate() {
        StructuredSelection selExisting;
        Object object = selExisting = this.existingModelCombo != null ? (IStructuredSelection)this.existingModelCombo.getSelection() : StructuredSelection.EMPTY;
        if (this.outputText != null) {
            this.outputText.getText().trim();
        }
        String error = null;
        if (this.modelNames.isEmpty()) {
            error = "No models found in this schema.";
        } else if (selExisting.isEmpty()) {
            error = "Please select a model.";
        }
        this.setErrorMessage(error);
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(error == null);
        }
    }

    protected void okPressed() {
        IStructuredSelection selExisting = (IStructuredSelection)this.existingModelCombo.getSelection();
        this.selectedModel = selExisting.isEmpty() && !this.modelNames.isEmpty() ? this.modelNames.get(0) : (String)selExisting.getFirstElement();
        boolean exportShown = this.exportModelCombo.getCombo().getVisible();
        IStructuredSelection selExport = (IStructuredSelection)this.exportModelCombo.getSelection();
        this.selectedExportModel = !exportShown || selExport.isEmpty() ? this.selectedModel : (String)selExport.getFirstElement();
        this.disableValidation = this.disableValidationBtn.getSelection();
        this.datasets = this.datasetsText.getText().isBlank() ? null : this.datasetsText.getText().trim();
        this.baskets = this.basketsText.getText().isBlank() ? null : this.basketsText.getText().trim();
        this.topics = this.topicsText.getText().isBlank() ? null : this.topicsText.getText().trim();
        super.okPressed();
    }

    public String getSelectedModel() {
        return this.selectedModel;
    }

    public String getSelectedExportModel() {
        return this.selectedExportModel;
    }

    public boolean isDisableValidation() {
        return this.disableValidation;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getDatasets() {
        return this.datasets;
    }

    public String getBaskets() {
        return this.baskets;
    }

    public String getTopics() {
        return this.topics;
    }
}

