/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ili2pg.handlers;

import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2pg.PgMain;
import ch.so.agi.dbeaver.ili2pg.jobs.Ili2pgJob;
import ch.so.agi.dbeaver.ili2pg.log.Log;
import ch.so.agi.dbeaver.ili2pg.ui.Ili2pgExportDialog;
import ch.so.agi.dbeaver.ili2pg.ui.Ili2pgImportDialog;
import ch.so.agi.dbeaver.ili2pg.ui.Ili2pgImportSchemaDialog;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class Ili2pgHandler
extends AbstractHandler {
    private static final String CMD_SCHEMA_IMPORT = "ch.so.agi.dbeaver.ili2pg.commands.importSchema";
    private static final String CMD_DATA_IMPORT = "ch.so.agi.dbeaver.ili2pg.commands.importData";
    private static final String CMD_EXPORT = "ch.so.agi.dbeaver.ili2pg.commands.exportSchema";
    private static final String CMD_EXPORT_OPTS = "ch.so.agi.dbeaver.ili2pg.commands.exportSchemaWithOptions";
    private static final String CMD_VALIDATE = "ch.so.agi.dbeaver.ili2pg.commands.validateSchema";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Action action = Action.from(event.getCommand().getId());
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection) || ((IStructuredSelection)sel).isEmpty()) {
            return null;
        }
        Object first = ((IStructuredSelection)sel).getFirstElement();
        if (action == Action.SCHEMA_IMPORT) {
            DBSInstance database = this.extractDatabase(first);
            if (database == null) {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                MessageDialog.openInformation((Shell)window.getShell(), (String)"", (String)"Not a PostgreSQL database.");
                return null;
            }
            Log.info("Database: " + String.valueOf(database));
            Ili2pgImportSchemaDialog dlg = new Ili2pgImportSchemaDialog(shell);
            if (dlg.open() == 0) {
                String ini = dlg.getIniPath();
                String ilidata = dlg.getIliDataRef();
                String schema = dlg.getTargetSchema();
                Config settings = this.createConfig();
                if (ini != null) {
                    settings.setMetaConfigFile(ini);
                } else {
                    settings.setMetaConfigFile(ilidata);
                }
                settings.setDbschema(schema);
                new Ili2pgJob(shell, (DBSObject)database, settings, Ili2pgJob.Mode.SCHEMA_IMPORT).schedule();
            }
            return null;
        }
        if (action == Action.IMPORT) {
            List<String> modelNames;
            DBSSchema schema = this.extractSchema(first);
            if (schema == null) {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                MessageDialog.openInformation((Shell)window.getShell(), (String)"", (String)"Not a PostgreSQL schema.");
                return null;
            }
            Log.info("Schema: " + String.valueOf(schema));
            if (!this.ensureActiveDatabaseMatches(schema, shell, action)) {
                return null;
            }
            try {
                modelNames = this.loadModelNames(schema);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)"ili2pg", (String)this.formatLoadModelNamesError(e));
                return null;
            }
            Log.info("modelNames: " + String.valueOf(modelNames));
            if (modelNames.isEmpty()) {
                MessageDialog.openInformation((Shell)shell, (String)"ili2pg", (String)("No rows in " + schema.getName() + ".t_ili2db_model (or table missing)."));
                return null;
            }
            Config settings = this.createConfig();
            Ili2pgImportDialog dlg = new Ili2pgImportDialog(shell, modelNames);
            if (dlg.open() != 0) {
                return null;
            }
            String modelName = this.sanitizeModelName(dlg.getSelectedModel());
            settings.setModels(modelName);
            if (dlg.isDisableValidation()) {
                settings.setValidation(false);
            }
            if (dlg.getDataset() != null) {
                settings.setDatasetName(dlg.getDataset());
            }
            if (dlg.getBaskets() != null) {
                settings.setBaskets(dlg.getBaskets());
            }
            if (dlg.getTopics() != null) {
                settings.setTopics(dlg.getTopics());
            }
            if (dlg.getTransferFilePath() != null) {
                settings.setXtffile(dlg.getTransferFilePath());
            }
            if (dlg.getExternalTransferRef() != null) {
                settings.setXtffile(dlg.getExternalTransferRef());
            }
            new Ili2pgJob(shell, (DBSObject)schema, settings, Ili2pgJob.Mode.IMPORT).schedule();
        } else {
            List<String> modelNames;
            DBSSchema schema = this.extractSchema(first);
            if (schema == null) {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                MessageDialog.openInformation((Shell)window.getShell(), (String)"", (String)"Not a PostgreSQL schema.");
                return null;
            }
            Log.info("Schema: " + String.valueOf(schema));
            if (!this.ensureActiveDatabaseMatches(schema, shell, action)) {
                return null;
            }
            try {
                modelNames = this.loadModelNames(schema);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)"ili2pg", (String)this.formatLoadModelNamesError(e));
                return null;
            }
            Log.info("modelNames: " + String.valueOf(modelNames));
            if (modelNames.isEmpty()) {
                MessageDialog.openInformation((Shell)shell, (String)"ili2pg", (String)("No rows in " + schema.getName() + ".t_ili2db_model (or table missing)."));
                return null;
            }
            Config settings = this.createConfig();
            switch (action) {
                case EXPORT: 
                case VALIDATE: {
                    String chosenModel = null;
                    if (modelNames.size() > 1) {
                        ElementListSelectionDialog dlg = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                        dlg.setTitle("Select ili2pg model");
                        dlg.setMessage("Choose a model from schema: " + schema.getName());
                        dlg.setMultipleSelection(false);
                        dlg.setElements((Object[])modelNames.toArray(new String[0]));
                        if (dlg.open() != 0) {
                            return null;
                        }
                        chosenModel = (String)dlg.getFirstResult();
                    } else {
                        chosenModel = modelNames.get(0);
                    }
                    chosenModel = this.sanitizeModelName(chosenModel);
                    settings.setModels(chosenModel);
                    if (action == Action.EXPORT) {
                        new Ili2pgJob(shell, (DBSObject)schema, settings, Ili2pgJob.Mode.EXPORT).schedule();
                        break;
                    }
                    new Ili2pgJob(shell, (DBSObject)schema, settings, Ili2pgJob.Mode.VALIDATE).schedule();
                    break;
                }
                case EXPORT_WITH_OPTIONS: {
                    Ili2pgExportDialog dlg = new Ili2pgExportDialog(shell, schema.getName(), modelNames);
                    if (dlg.open() != 0) {
                        return null;
                    }
                    String modelName = this.sanitizeModelName(dlg.getSelectedModel());
                    settings.setModels(modelName);
                    if (dlg.isDisableValidation()) {
                        settings.setValidation(false);
                    }
                    if (dlg.getDatasets() != null) {
                        settings.setDatasetName(dlg.getDatasets());
                    }
                    if (dlg.getBaskets() != null) {
                        settings.setBaskets(dlg.getBaskets());
                    }
                    if (dlg.getTopics() != null) {
                        settings.setTopics(dlg.getTopics());
                    }
                    if (dlg.getExportDir() != null && !dlg.getExportDir().isEmpty()) {
                        Path xtfPath = Paths.get(dlg.getExportDir(), schema.getName() + ".xtf");
                        settings.setXtffile(xtfPath.toAbsolutePath().toString());
                    }
                    new Ili2pgJob(shell, (DBSObject)schema, settings, Ili2pgJob.Mode.EXPORT).schedule();
                }
            }
        }
        return null;
    }

    private Config createConfig() {
        Config settings = new Config();
        new PgMain().initConfig(settings);
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "ch.so.agi.dbeaver.ili2pg");
        String ilidir = store.getString("ilidir");
        if (!ilidir.isBlank()) {
            settings.setModeldir(ilidir);
        } else {
            settings.setModeldir("%ILI_DIR;http://models.interlis.ch/;%JAR_DIR");
        }
        return settings;
    }

    private String sanitizeModelName(String modelName) {
        if (modelName.contains("{")) {
            return modelName.substring(0, modelName.indexOf("{"));
        }
        return modelName;
    }

    private DBSSchema extractSchema(Object element) {
        if (element instanceof DBNDatabaseItem) {
            DBSObject obj;
            DBSObject p = obj = ((DBNDatabaseItem)element).getObject();
            while (p != null) {
                if (p instanceof PostgreSchema) {
                    return (DBSSchema)p;
                }
                p = p.getParentObject();
            }
        }
        return null;
    }

    private DBSInstance extractDatabase(Object element) {
        if (element instanceof DBNDatabaseItem) {
            DBSObject obj;
            DBSObject p = obj = ((DBNDatabaseItem)element).getObject();
            while (p != null) {
                if (p instanceof PostgreDatabase) {
                    return (DBSInstance)p;
                }
                p = p.getParentObject();
            }
        }
        return null;
    }

    private boolean ensureActiveDatabaseMatches(DBSSchema schema, Shell shell, Action action) {
        String schemaDatabaseName = this.normalizeDatabaseName(this.getSchemaDatabaseName(schema));
        String activeDatabaseName = this.normalizeDatabaseName(this.getActiveDatabaseName(schema));
        String configuredDatabaseName = this.normalizeDatabaseName(this.getConfiguredDatabaseName(schema));
        if (schemaDatabaseName == null || activeDatabaseName == null) {
            return true;
        }
        if (schemaDatabaseName.equalsIgnoreCase(activeDatabaseName)) {
            return true;
        }
        Log.warn("Blocked " + String.valueOf((Object)action) + " on schema '" + schema.getName() + "': schema DB='" + schemaDatabaseName + "', runtime active DB='" + activeDatabaseName + "', config DB='" + configuredDatabaseName + "'.");
        MessageDialog.openWarning((Shell)shell, (String)"ili2pg", (String)("The selected schema belongs to database \"" + schemaDatabaseName + "\", but the active database is \"" + activeDatabaseName + "\".\n\n" + this.actionLabel(action) + " works only on the active/default database (bold in the navigator).\nPlease set \"" + schemaDatabaseName + "\" as default (bold) in the navigator or set it in Connection configuration, then retry.\nWith \"Show all databases\", only the currently active/default (bold) database can be used for this action."));
        return false;
    }

    private String actionLabel(Action action) {
        switch (action) {
            case IMPORT: {
                return "Import";
            }
            case EXPORT: 
            case EXPORT_WITH_OPTIONS: {
                return "Export";
            }
            case VALIDATE: {
                return "Validate";
            }
        }
        return "This action";
    }

    private String getSchemaDatabaseName(DBSSchema schema) {
        DBSSchema p = schema;
        while (p != null) {
            if (p instanceof PostgreDatabase) {
                return p.getName();
            }
            p = p.getParentObject();
        }
        return null;
    }

    private String getActiveDatabaseName(DBSSchema schema) {
        DBPDataSource ds = schema.getDataSource();
        if (ds == null) {
            return null;
        }
        try {
            DBSInstance defaultInstance = ds.getDefaultInstance();
            String runtimeDefaultName = this.normalizeDatabaseName(defaultInstance == null ? null : defaultInstance.getName());
            if (runtimeDefaultName != null) {
                return runtimeDefaultName;
            }
        }
        catch (Exception e) {
            Log.warn("Could not determine runtime active database from default instance: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        return this.getConfiguredDatabaseName(schema);
    }

    private String getConfiguredDatabaseName(DBSSchema schema) {
        DBPDataSource ds = schema.getDataSource();
        if (ds == null) {
            return null;
        }
        DBPDataSourceContainer container = ds.getContainer();
        if (container == null) {
            return null;
        }
        DBPConnectionConfiguration cc = container.getActualConnectionConfiguration();
        if (cc == null) {
            return null;
        }
        String dbName = this.normalizeDatabaseName(cc.getDatabaseName());
        if (dbName != null) {
            return dbName;
        }
        return this.normalizeDatabaseName(this.extractDatabaseNameFromJdbcUrl(cc.getUrl()));
    }

    private String extractDatabaseNameFromJdbcUrl(String jdbcUrl) {
        String path;
        block4: {
            if (jdbcUrl == null || jdbcUrl.isBlank() || !jdbcUrl.startsWith("jdbc:")) {
                return null;
            }
            String jdbcBody = jdbcUrl.substring("jdbc:".length());
            try {
                URI uri = new URI(jdbcBody);
                path = uri.getPath();
                if (path != null && !path.isBlank() && !"/".equals(path)) break block4;
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.warn("Could not parse JDBC URL to determine database name: " + jdbcUrl);
                return null;
            }
        }
        String dbName = path.substring(path.lastIndexOf(47) + 1);
        return dbName.isBlank() ? null : dbName;
    }

    private String normalizeDatabaseName(String name) {
        if (name == null) {
            return null;
        }
        String normalized = this.unquoteIdentifier(name.trim());
        return normalized.isBlank() ? null : normalized;
    }

    private String unquoteIdentifier(String value) {
        if (value.length() >= 2 && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1).trim();
        }
        return value;
    }

    private String formatLoadModelNamesError(Exception e) {
        String base = "Failed to load model names";
        if (e instanceof ModelNamesLoadException) {
            ModelNamesLoadException failure = (ModelNamesLoadException)e;
            String detail = this.firstErrorMessage(failure.getCause());
            if (failure.reconnectAttempted && failure.reconnectFailed) {
                return base + ". The database connection appears to have been lost and automatic reconnect failed (possible idle timeout or network drop)." + detail;
            }
            if (failure.reconnectAttempted) {
                return base + ". Automatic reconnect was attempted, but the query still failed." + detail;
            }
            return base + detail;
        }
        return base + this.firstErrorMessage(e);
    }

    private String firstErrorMessage(Throwable t) {
        Throwable cur = t;
        while (cur != null) {
            String msg = cur.getMessage();
            if (msg != null && !msg.isBlank()) {
                return ": " + msg;
            }
            cur = cur.getCause();
        }
        return "";
    }

    private boolean isConnectionLost(Throwable t) {
        Throwable cur = t;
        while (cur != null) {
            String className;
            SQLException sqlException;
            String sqlState;
            if (cur instanceof SQLException && (sqlState = (sqlException = (SQLException)cur).getSQLState()) != null && sqlState.startsWith("08")) {
                return true;
            }
            String msg = cur.getMessage();
            String probe = ((msg == null ? "" : msg) + " " + (className = cur.getClass().getName())).toLowerCase(Locale.ROOT);
            if (probe.contains("i/o error occurred while sending to the backend") || probe.contains("connection reset") || probe.contains("broken pipe") || probe.contains("eofexception") || probe.contains("connection is closed") || probe.contains("connection has been closed")) {
                return true;
            }
            cur = cur.getCause();
        }
        return false;
    }

    private boolean tryReconnect(DBSSchema schema, DBRProgressMonitor monitor) {
        DBPDataSource ds = schema.getDataSource();
        if (ds == null || ds.getContainer() == null) {
            Log.warn("Reconnect skipped while loading model names for schema '" + schema.getName() + "': no data source container available.");
            return false;
        }
        DBPDataSourceContainer container = ds.getContainer();
        String containerName = container.getName();
        Log.warn("Connection lost while loading model names for schema '" + schema.getName() + "'. Trying reconnect for data source '" + containerName + "'.");
        try {
            boolean ok = container.reconnect(monitor);
            if (ok) {
                Log.info("Reconnect succeeded for data source '" + containerName + "'.");
            } else {
                Log.warn("Reconnect returned false for data source '" + containerName + "'.");
            }
            return ok;
        }
        catch (Exception e) {
            Log.warn("Reconnect failed for data source '" + containerName + "': " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return false;
        }
    }

    private List<String> loadModelNames(DBSSchema schema) throws SQLException, DBCException, ModelNamesLoadException {
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        try {
            return this.loadModelNamesOnce(schema, (DBRProgressMonitor)monitor);
        }
        catch (SQLException | DBCException firstError) {
            if (!this.isConnectionLost(firstError)) {
                throw firstError;
            }
            boolean reconnectOk = this.tryReconnect(schema, (DBRProgressMonitor)monitor);
            if (!reconnectOk) {
                throw new ModelNamesLoadException(firstError, true, true);
            }
            try {
                return this.loadModelNamesOnce(schema, (DBRProgressMonitor)monitor);
            }
            catch (SQLException | DBCException retryError) {
                throw new ModelNamesLoadException(retryError, true, false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> loadModelNamesOnce(DBSSchema schema, DBRProgressMonitor monitor) throws SQLException, DBCException {
        DBPDataSource ds = schema.getDataSource();
        String qSchema = DBUtils.getQuotedIdentifier((DBSObject)schema);
        String qTable = DBUtils.getQuotedIdentifier((DBPDataSource)ds, (String)"t_ili2db_model");
        String sql = "SELECT modelname, content FROM " + qSchema + "." + qTable + " ORDER BY modelname";
        LinkedHashSet<String> uniq = new LinkedHashSet<String>();
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)ds, (String)"Read INTERLIS model names");
            try {
                block19: {
                    JDBCPreparedStatement stmt = session.prepareStatement(sql);
                    try {
                        try (JDBCResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                String v = JDBCUtils.safeGetString((ResultSet)rs, (int)1);
                                String c = JDBCUtils.safeGetString((ResultSet)rs, (int)2);
                                if (v == null || v.isEmpty() || c.contains("CONTRACTED") || c.contains("TYPE") || c.contains("REFSYSTEM") || c.contains("SYMBOLOGY")) continue;
                                uniq.add(v);
                            }
                        }
                        if (stmt == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stmt == null) throw throwable;
                        stmt.close();
                        throw throwable;
                    }
                    stmt.close();
                }
                if (session == null) return new ArrayList<String>(uniq);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (session == null) throw throwable;
                session.close();
                throw throwable;
            }
            session.close();
            return new ArrayList<String>(uniq);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private static enum Action {
        SCHEMA_IMPORT,
        IMPORT,
        EXPORT,
        EXPORT_WITH_OPTIONS,
        VALIDATE;


        static Action from(String id) {
            if (Ili2pgHandler.CMD_EXPORT.equals(id)) {
                return EXPORT;
            }
            if (Ili2pgHandler.CMD_EXPORT_OPTS.equals(id)) {
                return EXPORT_WITH_OPTIONS;
            }
            if (Ili2pgHandler.CMD_VALIDATE.equals(id)) {
                return VALIDATE;
            }
            if (Ili2pgHandler.CMD_SCHEMA_IMPORT.equals(id)) {
                return SCHEMA_IMPORT;
            }
            if (Ili2pgHandler.CMD_DATA_IMPORT.equals(id)) {
                return IMPORT;
            }
            return EXPORT;
        }
    }

    private static final class ModelNamesLoadException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final boolean reconnectAttempted;
        private final boolean reconnectFailed;

        private ModelNamesLoadException(Throwable cause, boolean reconnectAttempted, boolean reconnectFailed) {
            super(cause);
            this.reconnectAttempted = reconnectAttempted;
            this.reconnectFailed = reconnectFailed;
        }
    }
}

