/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ili2pg.jobs;

import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2pg.PgMain;
import ch.so.agi.dbeaver.ili2pg.log.Log;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.progress.IProgressConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class Ili2pgJob
extends Job {
    private static final String PLUGIN_ID = "ch.so.agi.dbeaver.ili2pg";
    private final Shell parentShell;
    private DBSSchema schema;
    private DBSInstance database;
    private final Config settings;
    private final Mode mode;

    public Ili2pgJob(Shell parentShell, DBSObject dbsObject, Config settings, Mode mode) {
        super("ili2pg job");
        this.parentShell = parentShell;
        if (dbsObject instanceof DBSSchema) {
            this.schema = (DBSSchema)dbsObject;
        } else {
            this.database = (DBSInstance)dbsObject;
        }
        this.settings = settings;
        this.mode = mode;
        this.setUser(true);
        this.setPriority(30);
        this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logConnectionSelection(Mode mode, String targetDatabaseName, DBPConnectionConfiguration connectionConfiguration) {
        String effectiveDatabaseName = this.resolveDatabaseNameFromConnectionConfiguration(connectionConfiguration);
        Log.info("ili2pg " + String.valueOf((Object)mode) + ": target DB='" + targetDatabaseName + "', effective connection DB='" + effectiveDatabaseName + "'.");
    }

    private DBPConnectionConfiguration resolveEffectiveConnectionConfig(DBPDataSourceContainer container, String targetDatabaseName) {
        if (container == null) {
            return null;
        }
        DBPConnectionConfiguration actual = container.getActualConnectionConfiguration();
        if (actual == null) {
            return null;
        }
        DBPConnectionConfiguration effective = new DBPConnectionConfiguration(actual);
        String normalizedTargetDatabaseName = this.normalizeDatabaseName(targetDatabaseName);
        if (normalizedTargetDatabaseName == null) {
            return effective;
        }
        effective.setDatabaseName(normalizedTargetDatabaseName);
        String jdbcUrl = effective.getUrl();
        if (jdbcUrl != null && !jdbcUrl.isBlank()) {
            try {
                String updatedJdbcUrl = PostgreUtils.updateDatabaseNameInURL((String)jdbcUrl, (String)normalizedTargetDatabaseName);
                if (updatedJdbcUrl != null && !updatedJdbcUrl.isBlank()) {
                    effective.setUrl(updatedJdbcUrl);
                }
            }
            catch (Exception e) {
                Log.warn("Could not update JDBC URL with target DB '" + normalizedTargetDatabaseName + "': " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
        return effective;
    }

    private String resolveTargetDatabaseName(DBSObject dbsObject) {
        if (dbsObject == null) {
            return null;
        }
        if (dbsObject instanceof DBSSchema) {
            DBSSchema schemaObject;
            DBSSchema p = schemaObject = (DBSSchema)dbsObject;
            while (p != null) {
                if (p instanceof PostgreDatabase) {
                    return this.normalizeDatabaseName(p.getName());
                }
                p = p.getParentObject();
            }
            return null;
        }
        if (dbsObject instanceof DBSInstance) {
            DBSInstance instance = (DBSInstance)dbsObject;
            return this.normalizeDatabaseName(instance.getName());
        }
        return null;
    }

    private String resolveDatabaseNameFromConnectionConfiguration(DBPConnectionConfiguration connectionConfiguration) {
        if (connectionConfiguration == null) {
            return null;
        }
        String dbName = this.normalizeDatabaseName(connectionConfiguration.getDatabaseName());
        if (dbName != null) {
            return dbName;
        }
        return this.normalizeDatabaseName(this.extractDatabaseNameFromJdbcUrl(connectionConfiguration.getUrl()));
    }

    private String extractDatabaseNameFromJdbcUrl(String jdbcUrl) {
        String path;
        block4: {
            if (jdbcUrl == null || jdbcUrl.isBlank() || !jdbcUrl.startsWith("jdbc:")) {
                return null;
            }
            String jdbcBody = jdbcUrl.substring("jdbc:".length());
            try {
                URI uri = new URI(jdbcBody);
                path = uri.getPath();
                if (path != null && !path.isBlank() && !"/".equals(path)) break block4;
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.warn("Could not parse JDBC URL to determine database name: " + jdbcUrl);
                return null;
            }
        }
        String dbName = path.substring(path.lastIndexOf(47) + 1);
        return dbName.isBlank() ? null : dbName;
    }

    private String normalizeDatabaseName(String name) {
        if (name == null) {
            return null;
        }
        String normalized = this.unquoteIdentifier(name.trim());
        return normalized.isBlank() ? null : normalized;
    }

    private String unquoteIdentifier(String value) {
        if (value.length() >= 2 && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1).trim();
        }
        return value;
    }

    private Config createConfig() {
        Config settings = new Config();
        new PgMain().initConfig(settings);
        return settings;
    }

    private IStatus error(String msg) {
        this.doneAsync("ili2pg export failed", msg);
        return new Status(4, PLUGIN_ID, msg);
    }

    private IStatus error(String msg, Throwable t) {
        this.doneAsync("ili2pg export failed", msg);
        return new Status(4, PLUGIN_ID, msg, t);
    }

    private void doneAsync(String title, String body) {
        Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)(this.parentShell != null ? this.parentShell : Display.getDefault().getActiveShell()), (String)title, (String)body));
    }

    private MessageConsole getConsole(String name) {
        IConsoleManager mgr = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = mgr.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole c = iConsoleArray[n2];
            if (name.equals(c.getName())) {
                return (MessageConsole)c;
            }
            ++n2;
        }
        MessageConsole console = new MessageConsole(name, null);
        mgr.addConsoles(new IConsole[]{console});
        return console;
    }

    private void showConsole(MessageConsole console) {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
    }

    public static enum Mode {
        SCHEMA_IMPORT,
        IMPORT,
        EXPORT,
        VALIDATE;

    }
}

