/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.dbeaver.ili2pg.log;

import ch.ehi.basics.logging.AbstractFilteringListener;
import ch.ehi.basics.logging.LogEvent;
import ch.interlis.iox.IoxLogEvent;
import java.util.ArrayList;
import org.eclipse.ui.console.MessageConsoleStream;

public class EclipseConsoleLogListener
extends AbstractFilteringListener {
    private int ioxErrc = 0;
    private String logfile = null;
    private static final String INFO = "Info";
    private static MessageConsoleStream out;
    private static MessageConsoleStream err;

    public EclipseConsoleLogListener(MessageConsoleStream out, MessageConsoleStream err) {
        EclipseConsoleLogListener.out = out;
        EclipseConsoleLogListener.err = err;
    }

    public void setLogfileName(String fileName) {
        this.logfile = fileName;
    }

    public void outputEvent(LogEvent event, ArrayList msgv) {
        Object msgTag = this.getMessageTag(event);
        msgTag = msgTag == null ? "" : (String)msgTag + ": ";
        Object msgTimestamp = null;
        msgTimestamp = this.getTimestamp();
        msgTimestamp = msgTimestamp == null ? "" : (String)msgTimestamp + ": ";
        Object objRef = null;
        if (event instanceof IoxLogEvent) {
            if (this.isError(event.getEventKind())) {
                ++this.ioxErrc;
            }
            objRef = "";
            IoxLogEvent ioxEvent = (IoxLogEvent)event;
            if (ioxEvent.getSourceLineNr() != null) {
                objRef = (String)objRef + "line " + String.valueOf(ioxEvent.getSourceLineNr()) + ": ";
            }
            if (ioxEvent.getSourceObjectTag() != null) {
                objRef = (String)objRef + ioxEvent.getSourceObjectTag() + ": ";
            }
            if (ioxEvent.getSourceObjectTechId() != null) {
                objRef = (String)objRef + ioxEvent.getSourceObjectTechId() + ": ";
            }
            if (ioxEvent.getSourceObjectXtfId() != null) {
                objRef = (String)objRef + "tid " + ioxEvent.getSourceObjectXtfId() + ": ";
            }
            if (ioxEvent.getSourceObjectUsrId() != null) {
                objRef = (String)objRef + ioxEvent.getSourceObjectUsrId() + ": ";
            }
        } else {
            objRef = "";
        }
        for (String msg : msgv) {
            this.outputMsgLine(event.getEventKind(), event.getCustomLevel(), (String)msgTimestamp + (String)msgTag + (String)objRef + msg);
        }
        if (event instanceof IoxLogEvent && this.logfile != null && this.ioxErrc == 1 && this.isError(event.getEventKind())) {
            this.outputMsgLine(6, 0, (String)msgTimestamp + "Info: see <" + this.logfile + "> for more validation results");
        }
    }

    public void outputMsgLine(int kind, int level, String msg) {
        if (msg.endsWith("\n")) {
            err.print(msg);
        } else {
            err.println(msg);
        }
    }

    public String getMessageTag(LogEvent event) {
        switch (event.getEventKind()) {
            case 7: {
                return "Error";
            }
            case 6: {
                return "Warning";
            }
        }
        return INFO;
    }

    private boolean isError(int kind) {
        return kind == 7 || kind == 6;
    }

    public boolean skipEvent(LogEvent event) {
        if (event instanceof IoxLogEvent && this.ioxErrc > 0 && this.logfile != null && this.isError(event.getEventKind())) {
            return true;
        }
        return super.skipEvent(event);
    }

    public int getErrorCount() {
        return this.ioxErrc;
    }
}

